/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.testable.processor.translator;

import com.alibaba.testable.processor.exception.MemberNotExistException;
import com.alibaba.testable.processor.model.MemberRecord;
import com.alibaba.testable.processor.model.TestableContext;
import com.sun.tools.javac.tree.JCTree;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class PrivateAccessChecker {
    private static final String CLASS_NAME_PRIVATE_ACCESSOR = "PrivateAccessor";
    private static final List<String> FIELD_ACCESS_METHOD = Arrays.asList((Object[])new String[]{"get", "set", "getStatic", "setStatic"}.clone());
    private static final List<String> FIELD_INVOKE_METHOD = Arrays.asList((Object[])new String[]{"invoke", "invokeStatic"}.clone());
    private static final String TYPE_FIELD = "Field";
    private static final String TYPE_METHOD = "Method";
    private final TestableContext cx;
    private final String className;
    private final MemberRecord sourceMembers;

    public PrivateAccessChecker(TestableContext cx, String className, MemberRecord memberRecord) {
        this.cx = cx;
        this.className = className;
        this.sourceMembers = memberRecord;
    }

    public void validate(JCTree.JCMethodInvocation invocation) {
        if (invocation.meth instanceof JCTree.JCFieldAccess && invocation.args.length() >= 2) {
            Object target;
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)invocation.meth;
            if (invocation.args.get(1) instanceof JCTree.JCLiteral && this.isPrivateAccessor(fieldAccess) && (target = ((JCTree.JCLiteral)invocation.args.get(1)).getValue()) instanceof String) {
                String methodName = fieldAccess.name.toString();
                if (FIELD_ACCESS_METHOD.contains(methodName)) {
                    if (this.sourceMembers.nonPrivateNorFinalFields.contains(target)) {
                        this.cx.logger.warn("Field " + this.className + "::" + target + " is neither private nor final.");
                    } else if (!this.sourceMembers.privateOrFinalFields.contains(target)) {
                        throw new MemberNotExistException(TYPE_FIELD, this.className, (String)target);
                    }
                } else if (FIELD_INVOKE_METHOD.contains(methodName)) {
                    int parameterCount = invocation.args.length() - 2;
                    if (!this.sourceMembers.privateMethods.containsKey(target) || !this.checkParameterCount(this.sourceMembers.privateMethods, (String)target, parameterCount)) {
                        if (this.sourceMembers.nonPrivateMethods.containsKey(target) && this.checkParameterCount(this.sourceMembers.nonPrivateMethods, (String)target, parameterCount)) {
                            this.cx.logger.warn("Method " + this.className + "::" + target + " is not private.");
                        } else {
                            throw new MemberNotExistException(TYPE_METHOD, this.className, (String)target, parameterCount);
                        }
                    }
                }
            }
        }
    }

    private boolean isPrivateAccessor(JCTree.JCFieldAccess fieldAccess) {
        return this.isPrivateAccessorWithShortRef(fieldAccess) || this.isPrivateAccessorWithFullRef(fieldAccess);
    }

    private boolean isPrivateAccessorWithShortRef(JCTree.JCFieldAccess fieldAccess) {
        return fieldAccess.selected instanceof JCTree.JCIdent && ((JCTree.JCIdent)fieldAccess.selected).name.toString().equals(CLASS_NAME_PRIVATE_ACCESSOR);
    }

    private boolean isPrivateAccessorWithFullRef(JCTree.JCFieldAccess fieldAccess) {
        return fieldAccess.selected instanceof JCTree.JCFieldAccess && fieldAccess.selected.toString().equals("com.alibaba.testable.core.tool.PrivateAccessor");
    }

    private boolean checkParameterCount(Map<String, List<Integer>> methods, String target, int parameterCount) {
        for (Integer expectCount : methods.get(target)) {
            if (!this.countMatch(parameterCount, expectCount)) continue;
            return true;
        }
        return false;
    }

    private boolean countMatch(int parameterCount, Integer expectCount) {
        return expectCount == parameterCount || expectCount < 0 && parameterCount >= -expectCount.intValue();
    }
}

