/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.concurrent;

import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import com.alibaba.p3c.pmd.lang.java.rule.util.NodeUtils;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.dfa.DataFlowNode;
import net.sourceforge.pmd.lang.dfa.StartOrEndDataFlowNode;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSynchronizedStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.Token;

public class AvoidCallStaticSimpleDateFormatRule
extends AbstractAliRule {
    private static final String FORMAT_METHOD_NAME = "format";

    public Object visit(ASTMethodDeclaration node, Object data) {
        if (node.isSynchronized()) {
            return super.visit(node, data);
        }
        this.handleMethod(node, data);
        return super.visit(node, data);
    }

    private void handleMethod(ASTMethodDeclaration methodDeclaration, Object data) {
        DataFlowNode dataFlowNode = methodDeclaration.getDataFlowNode();
        if (dataFlowNode == null || dataFlowNode.getFlow() == null) {
            return;
        }
        Stack<Node> stack = new Stack<Node>();
        HashSet<String> localSimpleDateFormatNames = new HashSet<String>();
        for (DataFlowNode flowNode : dataFlowNode.getFlow()) {
            this.handleFlowNode(stack, localSimpleDateFormatNames, flowNode);
        }
        while (!stack.isEmpty()) {
            Node node = (Node)stack.pop();
            if (!(node instanceof ASTPrimaryExpression)) continue;
            this.addViolationWithMessage(data, node, "java.concurrent.AvoidCallStaticSimpleDateFormatRule.violation.msg", new Object[]{this.getExpressName((ASTPrimaryExpression)node)});
        }
    }

    private void handleFlowNode(Stack<Node> stack, Set<String> localSimpleDateFormatNames, DataFlowNode flowNode) {
        AbstractJavaNode javaNode;
        ASTPrimaryExpression flowPrimaryExpression;
        ASTVariableDeclarator variableDeclarator;
        if (flowNode instanceof StartOrEndDataFlowNode || flowNode.getNode() instanceof ASTMethodDeclaration) {
            return;
        }
        if (flowNode.getNode() instanceof ASTVariableDeclarator && (variableDeclarator = (ASTVariableDeclarator)flowNode.getNode()).getType() == SimpleDateFormat.class) {
            ASTVariableDeclaratorId variableDeclaratorId = (ASTVariableDeclaratorId)variableDeclarator.getFirstChildOfType(ASTVariableDeclaratorId.class);
            localSimpleDateFormatNames.add(variableDeclaratorId.getImage());
            return;
        }
        if (flowNode.getNode() instanceof ASTStatementExpression) {
            ASTStatementExpression statementExpression = (ASTStatementExpression)flowNode.getNode();
            if (NodeUtils.isLockStatementExpression(statementExpression)) {
                stack.push(flowNode.getNode());
                return;
            }
            if (NodeUtils.isUnLockStatementExpression(statementExpression)) {
                Node node;
                while (!stack.isEmpty() && !NodeUtils.isLockNode(node = stack.pop())) {
                }
                return;
            }
        }
        if ((flowPrimaryExpression = (ASTPrimaryExpression)(javaNode = (AbstractJavaNode)flowNode.getNode()).getFirstDescendantOfType(ASTPrimaryExpression.class)) == null) {
            return;
        }
        if (flowPrimaryExpression.getFirstParentOfType(ASTSynchronizedStatement.class) != null) {
            return;
        }
        if (!this.isStaticSimpleDateFormatCall(flowPrimaryExpression, localSimpleDateFormatNames)) {
            return;
        }
        stack.push((Node)flowPrimaryExpression);
    }

    private String getExpressName(ASTPrimaryExpression primaryExpression) {
        ASTName name = (ASTName)primaryExpression.getFirstDescendantOfType(ASTName.class);
        return name.getImage();
    }

    private boolean isStaticSimpleDateFormatCall(ASTPrimaryExpression primaryExpression, Set<String> localSimpleDateFormatNames) {
        if (primaryExpression.jjtGetNumChildren() == 0) {
            return false;
        }
        ASTName name = (ASTName)primaryExpression.getFirstDescendantOfType(ASTName.class);
        if (name == null || name.getType() != SimpleDateFormat.class) {
            return false;
        }
        if (name.getNameDeclaration() == null || name.getNameDeclaration().getName() == null) {
            return false;
        }
        if (localSimpleDateFormatNames.contains(name.getNameDeclaration().getName())) {
            return false;
        }
        ASTPrimaryPrefix primaryPrefix = (ASTPrimaryPrefix)primaryExpression.jjtGetChild(0);
        if (primaryPrefix.getType() != SimpleDateFormat.class) {
            return false;
        }
        Token token = (Token)primaryPrefix.jjtGetLastToken();
        return FORMAT_METHOD_NAME.equals(token.image);
    }
}

