/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.inbound.mysql.tsdb;

import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnConstraint;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLColumnPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLColumnUniqueKey;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLNotNullConstraint;
import com.alibaba.druid.sql.ast.statement.SQLNullConstraint;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlPrimaryKey;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlUnique;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlOrderingExpr;
import com.alibaba.druid.sql.repository.Schema;
import com.alibaba.druid.sql.repository.SchemaObject;
import com.alibaba.druid.sql.repository.SchemaRepository;
import com.alibaba.druid.util.JdbcConstants;
import com.alibaba.otter.canal.parse.inbound.TableMeta;
import com.alibaba.otter.canal.parse.inbound.mysql.ddl.DruidDdlParser;
import com.alibaba.otter.canal.parse.inbound.mysql.tsdb.TableMetaTSDB;
import com.alibaba.otter.canal.protocol.position.EntryPosition;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryTableMeta
implements TableMetaTSDB {
    private Logger logger = LoggerFactory.getLogger(MemoryTableMeta.class);
    private Map<List<String>, TableMeta> tableMetas = new ConcurrentHashMap<List<String>, TableMeta>();
    private SchemaRepository repository = new SchemaRepository(JdbcConstants.MYSQL);

    @Override
    public boolean init(String destination) {
        return true;
    }

    @Override
    public void destory() {
        this.tableMetas.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean apply(EntryPosition position, String schema, String ddl, String extra) {
        this.tableMetas.clear();
        MemoryTableMeta memoryTableMeta = this;
        synchronized (memoryTableMeta) {
            if (StringUtils.isNotEmpty((String)schema)) {
                this.repository.setDefaultSchema(this.structureSchema(schema));
            }
            try {
                if (!(StringUtils.startsWithIgnoreCase((String)StringUtils.trim((String)ddl), (String)"flush") || StringUtils.startsWithIgnoreCase((String)StringUtils.trim((String)ddl), (String)"grant") || StringUtils.startsWithIgnoreCase((String)StringUtils.trim((String)ddl), (String)"revoke") || StringUtils.startsWithIgnoreCase((String)StringUtils.trim((String)ddl), (String)"create user") || StringUtils.startsWithIgnoreCase((String)StringUtils.trim((String)ddl), (String)"alter user") || StringUtils.startsWithIgnoreCase((String)StringUtils.trim((String)ddl), (String)"drop user") || StringUtils.startsWithIgnoreCase((String)StringUtils.trim((String)ddl), (String)"create database"))) {
                    this.repository.console(ddl);
                }
            }
            catch (Throwable e) {
                this.logger.warn("parse faield : " + ddl, e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableMeta find(String schema, String table) {
        List<String> keys = Arrays.asList(schema, table);
        TableMeta tableMeta = this.tableMetas.get(keys);
        if (tableMeta == null) {
            MemoryTableMeta memoryTableMeta = this;
            synchronized (memoryTableMeta) {
                tableMeta = this.tableMetas.get(keys);
                if (tableMeta == null) {
                    Schema schemaRep = this.repository.findSchema(schema);
                    if (schemaRep == null) {
                        return null;
                    }
                    SchemaObject data = schemaRep.findTable(table);
                    if (data == null) {
                        return null;
                    }
                    SQLStatement statement = data.getStatement();
                    if (statement == null) {
                        return null;
                    }
                    if (statement instanceof SQLCreateTableStatement) {
                        tableMeta = this.parse((SQLCreateTableStatement)statement);
                    }
                    if (tableMeta != null) {
                        if (table != null) {
                            tableMeta.setTable(table);
                        }
                        if (schema != null) {
                            tableMeta.setSchema(schema);
                        }
                        this.tableMetas.put(keys, tableMeta);
                    }
                }
            }
        }
        return tableMeta;
    }

    @Override
    public boolean rollback(EntryPosition position) {
        throw new RuntimeException("not support for memory");
    }

    @Override
    public Map<String, String> snapshot() {
        HashMap<String, String> schemaDdls = new HashMap<String, String>();
        for (Schema schema : this.repository.getSchemas()) {
            StringBuffer data = new StringBuffer(4096);
            for (String table : schema.showTables()) {
                SchemaObject schemaObject = schema.findTable(table);
                schemaObject.getStatement().output(data);
                data.append("; \n");
            }
            schemaDdls.put(schema.getName(), data.toString());
        }
        return schemaDdls;
    }

    private String structureSchema(String schema) {
        if (schema.startsWith("`") && schema.endsWith("`")) {
            return schema;
        }
        return "`" + schema + "`";
    }

    private TableMeta parse(SQLCreateTableStatement statement) {
        int size = statement.getTableElementList().size();
        if (size > 0) {
            TableMeta tableMeta = new TableMeta();
            for (int i = 0; i < size; ++i) {
                SQLTableElement element = (SQLTableElement)statement.getTableElementList().get(i);
                this.processTableElement(element, tableMeta);
            }
            return tableMeta;
        }
        return null;
    }

    private void processTableElement(SQLTableElement element, TableMeta tableMeta) {
        block17: {
            block18: {
                block16: {
                    int num;
                    if (!(element instanceof SQLColumnDefinition)) break block16;
                    TableMeta.FieldMeta fieldMeta = new TableMeta.FieldMeta();
                    SQLColumnDefinition column = (SQLColumnDefinition)element;
                    String name = this.getSqlName((SQLExpr)column.getName());
                    SQLDataType dataType = column.getDataType();
                    String dataTypStr = dataType.getName();
                    if (StringUtils.equalsIgnoreCase((String)dataTypStr, (String)"float") && dataType.getArguments().size() == 1 && (num = Integer.valueOf(((SQLExpr)dataType.getArguments().get(0)).toString()).intValue()) > 24) {
                        dataTypStr = "double";
                    }
                    if (dataType.getArguments().size() > 0) {
                        dataTypStr = dataTypStr + "(";
                        for (int i = 0; i < column.getDataType().getArguments().size(); ++i) {
                            if (i != 0) {
                                dataTypStr = dataTypStr + ",";
                            }
                            SQLExpr arg = (SQLExpr)column.getDataType().getArguments().get(i);
                            dataTypStr = dataTypStr + arg.toString();
                        }
                        dataTypStr = dataTypStr + ")";
                    }
                    if (dataType instanceof SQLDataTypeImpl) {
                        SQLDataTypeImpl dataTypeImpl = (SQLDataTypeImpl)dataType;
                        if (dataTypeImpl.isUnsigned()) {
                            dataTypStr = dataTypStr + " unsigned";
                        }
                        if (dataTypeImpl.isZerofill()) {
                            if (!dataTypeImpl.isUnsigned()) {
                                dataTypStr = dataTypStr + " unsigned";
                            }
                            dataTypStr = dataTypStr + " zerofill";
                        }
                    }
                    if (column.getDefaultExpr() == null || column.getDefaultExpr() instanceof SQLNullExpr) {
                        fieldMeta.setDefaultValue(null);
                    } else {
                        fieldMeta.setDefaultValue(DruidDdlParser.unescapeQuotaName(this.getSqlName(column.getDefaultExpr())));
                    }
                    fieldMeta.setColumnName(name);
                    fieldMeta.setColumnType(dataTypStr);
                    fieldMeta.setNullable(true);
                    List constraints = column.getConstraints();
                    for (SQLColumnConstraint constraint : constraints) {
                        if (constraint instanceof SQLNotNullConstraint) {
                            fieldMeta.setNullable(false);
                            continue;
                        }
                        if (constraint instanceof SQLNullConstraint) {
                            fieldMeta.setNullable(true);
                            continue;
                        }
                        if (constraint instanceof SQLColumnPrimaryKey) {
                            fieldMeta.setKey(true);
                            fieldMeta.setNullable(false);
                            continue;
                        }
                        if (!(constraint instanceof SQLColumnUniqueKey)) continue;
                        fieldMeta.setUnique(true);
                    }
                    tableMeta.addFieldMeta(fieldMeta);
                    break block17;
                }
                if (!(element instanceof MySqlPrimaryKey)) break block18;
                MySqlPrimaryKey column = (MySqlPrimaryKey)element;
                List pks = column.getColumns();
                for (SQLSelectOrderByItem pk : pks) {
                    String name = this.getSqlName(pk.getExpr());
                    TableMeta.FieldMeta field = tableMeta.getFieldMetaByName(name);
                    field.setKey(true);
                    field.setNullable(false);
                }
                break block17;
            }
            if (!(element instanceof MySqlUnique)) break block17;
            MySqlUnique column = (MySqlUnique)element;
            List uks = column.getColumns();
            for (SQLSelectOrderByItem uk : uks) {
                String name = this.getSqlName(uk.getExpr());
                TableMeta.FieldMeta field = tableMeta.getFieldMetaByName(name);
                field.setUnique(true);
            }
        }
    }

    private String getSqlName(SQLExpr sqlName) {
        if (sqlName == null) {
            return null;
        }
        if (sqlName instanceof SQLPropertyExpr) {
            SQLIdentifierExpr owner = (SQLIdentifierExpr)((SQLPropertyExpr)sqlName).getOwner();
            return DruidDdlParser.unescapeName(owner.getName()) + "." + DruidDdlParser.unescapeName(((SQLPropertyExpr)sqlName).getName());
        }
        if (sqlName instanceof SQLIdentifierExpr) {
            return DruidDdlParser.unescapeName(((SQLIdentifierExpr)sqlName).getName());
        }
        if (sqlName instanceof SQLCharExpr) {
            return ((SQLCharExpr)sqlName).getText();
        }
        if (sqlName instanceof SQLMethodInvokeExpr) {
            return DruidDdlParser.unescapeName(((SQLMethodInvokeExpr)sqlName).getMethodName());
        }
        if (sqlName instanceof MySqlOrderingExpr) {
            return this.getSqlName(((MySqlOrderingExpr)sqlName).getExpr());
        }
        return sqlName.toString();
    }

    public SchemaRepository getRepository() {
        return this.repository;
    }
}

