/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.driver.mysql.packets;

import com.alibaba.otter.canal.common.utils.CanalToStringStyle;
import com.alibaba.otter.canal.parse.driver.mysql.packets.IPacket;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class HeaderPacket
implements IPacket {
    private int packetBodyLength;
    private byte packetSequenceNumber;

    @Override
    public byte[] toBytes() {
        byte[] data = new byte[]{(byte)(this.packetBodyLength & 0xFF), (byte)(this.packetBodyLength >>> 8), (byte)(this.packetBodyLength >>> 16), this.getPacketSequenceNumber()};
        return data;
    }

    @Override
    public void fromBytes(byte[] data) {
        if (data == null || data.length != 4) {
            throw new IllegalArgumentException("invalid header data. It can't be null and the length must be 4 byte.");
        }
        this.packetBodyLength = data[0] & 0xFF | (data[1] & 0xFF) << 8 | (data[2] & 0xFF) << 16;
        this.setPacketSequenceNumber(data[3]);
    }

    public int getPacketBodyLength() {
        return this.packetBodyLength;
    }

    public void setPacketBodyLength(int packetBodyLength) {
        this.packetBodyLength = packetBodyLength;
    }

    public void setPacketSequenceNumber(byte packetSequenceNumber) {
        this.packetSequenceNumber = packetSequenceNumber;
    }

    public byte getPacketSequenceNumber() {
        return this.packetSequenceNumber;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)CanalToStringStyle.DEFAULT_STYLE);
    }
}

