/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.maintainer.client.remote;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.http.DefaultHttpClientFactory;
import com.alibaba.nacos.common.http.HttpClientBeanHolder;
import com.alibaba.nacos.common.http.HttpClientFactory;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientManager
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientManager.class);
    private static volatile HttpClientManager httpClientManager;
    private static final HttpClientFactory HTTP_CLIENT_FACTORY;

    private HttpClientManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpClientManager getInstance() {
        if (httpClientManager != null) return httpClientManager;
        Class<HttpClientManager> clazz = HttpClientManager.class;
        synchronized (HttpClientManager.class) {
            if (httpClientManager != null) return httpClientManager;
            httpClientManager = new HttpClientManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return httpClientManager;
        }
    }

    public NacosRestTemplate getNacosRestTemplate() {
        return HttpClientBeanHolder.getNacosRestTemplate((HttpClientFactory)HTTP_CLIENT_FACTORY);
    }

    public void shutdown() throws NacosException {
        LOGGER.info("[HttpClientManager] Start destroying NacosRestTemplate");
        try {
            HttpClientBeanHolder.shutdownNacosSyncRest((String)HTTP_CLIENT_FACTORY.getClass().getName());
        }
        catch (Exception ex) {
            LOGGER.error("[HttpClientManager] An exception occurred when the HTTP client was closed : {}", (Object)ExceptionUtil.getStackTrace((Throwable)ex));
        }
        LOGGER.info("[HttpClientManager] Completed destruction of NacosRestTemplate");
    }

    static {
        HTTP_CLIENT_FACTORY = new DefaultHttpClientFactory(LOGGER);
    }
}

