/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.util;

public class ClassUtils {
    public static ClassLoader getDefaultClassLoader() {
        try {
            return Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            ClassLoader classLoader = ClassUtils.class.getClassLoader();
            if (classLoader != null) {
                return classLoader;
            }
            try {
                return ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable2) {
                return null;
            }
        }
    }

    public static boolean isPresent(String className) {
        ClassLoader defaultClassLoader = ClassUtils.getDefaultClassLoader();
        try {
            if (defaultClassLoader != null) {
                defaultClassLoader.loadClass(className);
            } else {
                Class.forName(className);
            }
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }
}

