/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.utils;

import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.utils.TemplateUtils;
import com.alibaba.nacos.client.utils.TenantUtil;
import com.alibaba.nacos.common.utils.ConvertUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.VersionUtils;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientBasicParamUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientBasicParamUtil.class);
    private static final Pattern PATTERN = Pattern.compile("\\$\\{[^}]+\\}");
    private static final int DESENSITISE_PARAMETER_MIN_LENGTH = 2;
    private static final int DESENSITISE_PARAMETER_KEEP_ONE_CHAR_LENGTH = 8;
    private static final String NACOS_CLIENT_APP_KEY = "nacos.client.appKey";
    private static final String NACOS_CLIENT_CONTEXT_PATH_KEY = "nacos.client.contextPath";
    private static final String DEFAULT_NACOS_CLIENT_CONTEXT_PATH = "nacos";
    private static final String NACOS_SERVER_PORT_KEY = "nacos.server.port";
    private static final String DEFAULT_SERVER_PORT = "8848";
    private static final String BLANK_STR = "";
    private static String defaultContextPath;
    private static String appKey;
    private static String clientVersion;
    private static String serverPort;
    private static String defaultNodesPath;

    public static String getAppKey() {
        return appKey;
    }

    public static void setAppKey(String appKey) {
        ClientBasicParamUtil.appKey = appKey;
    }

    public static String getDefaultContextPath() {
        return defaultContextPath;
    }

    public static void setDefaultContextPath(String defaultContextPath) {
        ClientBasicParamUtil.defaultContextPath = defaultContextPath;
    }

    public static String getClientVersion() {
        return clientVersion;
    }

    public static void setClientVersion(String clientVersion) {
        ClientBasicParamUtil.clientVersion = clientVersion;
    }

    public static String getDefaultServerPort() {
        return serverPort;
    }

    public static String getDefaultNodesPath() {
        return defaultNodesPath;
    }

    public static void setDefaultNodesPath(String defaultNodesPath) {
        ClientBasicParamUtil.defaultNodesPath = defaultNodesPath;
    }

    public static String parseNamespace(NacosClientProperties properties) {
        String namespaceTmp = null;
        String isUseCloudNamespaceParsing = properties.getProperty("isUseCloudNamespaceParsing", properties.getProperty("nacos.use.cloud.namespace.parsing", String.valueOf(true)));
        if (Boolean.parseBoolean(isUseCloudNamespaceParsing)) {
            namespaceTmp = TenantUtil.getUserTenantForAcm();
            namespaceTmp = TemplateUtils.stringBlankAndThenExecute(namespaceTmp, () -> {
                String namespace = properties.getProperty("ALIBABA_ALIWARE_NAMESPACE");
                return StringUtils.isNotBlank((String)namespace) ? namespace : BLANK_STR;
            });
        }
        if (StringUtils.isBlank((CharSequence)namespaceTmp)) {
            namespaceTmp = properties.getProperty("namespace");
        }
        return StringUtils.isNotBlank((String)namespaceTmp) ? namespaceTmp.trim() : "public";
    }

    public static String parsingEndpointRule(String endpointUrl) {
        String endpointUrlSource;
        if (endpointUrl == null || !PATTERN.matcher(endpointUrl).find()) {
            String endpointUrlSource2 = NacosClientProperties.PROTOTYPE.getProperty("ALIBABA_ALIWARE_ENDPOINT_URL");
            if (StringUtils.isNotBlank((String)endpointUrlSource2)) {
                endpointUrl = endpointUrlSource2;
            }
            return StringUtils.isNotBlank((String)endpointUrl) ? endpointUrl : BLANK_STR;
        }
        endpointUrl = endpointUrl.substring(endpointUrl.indexOf("${") + 2, endpointUrl.lastIndexOf("}"));
        int defStartOf = endpointUrl.indexOf(":");
        String defaultEndpointUrl = null;
        if (defStartOf != -1) {
            defaultEndpointUrl = endpointUrl.substring(defStartOf + 1);
            endpointUrl = endpointUrl.substring(0, defStartOf);
        }
        if (StringUtils.isBlank((CharSequence)(endpointUrlSource = TemplateUtils.stringBlankAndThenExecute(NacosClientProperties.PROTOTYPE.getProperty(endpointUrl), () -> NacosClientProperties.PROTOTYPE.getProperty("ALIBABA_ALIWARE_ENDPOINT_URL"))))) {
            if (StringUtils.isNotBlank((String)defaultEndpointUrl)) {
                endpointUrl = defaultEndpointUrl;
            }
        } else {
            endpointUrl = endpointUrlSource;
        }
        return StringUtils.isNotBlank((String)endpointUrl) ? endpointUrl : BLANK_STR;
    }

    public static String getInputParameters(Properties properties) {
        boolean logAllParameters = ConvertUtils.toBoolean((String)properties.getProperty("logAllProperties"), (boolean)false);
        StringBuilder result = new StringBuilder();
        if (logAllParameters) {
            result.append("Log nacos client init properties with Full mode, This mode is only used for debugging and troubleshooting. ");
            result.append("Please close this mode by removing properties `logAllProperties` after finishing debug or troubleshoot.\n");
            result.append("Nacos client all init properties: \n");
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> result.append("\t").append(key.toString()).append("=").append(value.toString()).append("\n")));
        } else {
            result.append("Nacos client key init properties: \n");
            ClientBasicParamUtil.appendKeyParameters(result, properties, "serverAddr", false);
            ClientBasicParamUtil.appendKeyParameters(result, properties, "namespace", false);
            ClientBasicParamUtil.appendKeyParameters(result, properties, "endpoint", false);
            ClientBasicParamUtil.appendKeyParameters(result, properties, "endpointPort", false);
            ClientBasicParamUtil.appendKeyParameters(result, properties, "username", false);
            ClientBasicParamUtil.appendKeyParameters(result, properties, "password", true);
            ClientBasicParamUtil.appendKeyParameters(result, properties, "accessKey", false);
            ClientBasicParamUtil.appendKeyParameters(result, properties, "secretKey", true);
            ClientBasicParamUtil.appendKeyParameters(result, properties, "ramRoleName", false);
            ClientBasicParamUtil.appendKeyParameters(result, properties, "signatureRegionId", false);
        }
        return result.toString();
    }

    private static void appendKeyParameters(StringBuilder result, Properties properties, String propertyKey, boolean needDesensitise) {
        String propertyValue = properties.getProperty(propertyKey);
        if (StringUtils.isBlank((CharSequence)propertyValue)) {
            return;
        }
        result.append("\t").append(propertyKey).append("=").append(needDesensitise ? ClientBasicParamUtil.desensitiseParameter(propertyValue) : propertyValue).append("\n");
    }

    public static String desensitiseParameter(String parameterValue) {
        if (parameterValue.length() <= 2) {
            return parameterValue;
        }
        if (parameterValue.length() < 8) {
            return ClientBasicParamUtil.doDesensitiseParameter(parameterValue, 1);
        }
        return ClientBasicParamUtil.doDesensitiseParameter(parameterValue, 2);
    }

    private static String doDesensitiseParameter(String parameterValue, int keepCharCount) {
        StringBuilder result = new StringBuilder(parameterValue);
        for (int i = keepCharCount; i < parameterValue.length() - keepCharCount; ++i) {
            result.setCharAt(i, '*');
        }
        return result.toString();
    }

    public static String getNameSuffixByServerIps(String ... serverIps) {
        StringBuilder sb = new StringBuilder();
        String split = BLANK_STR;
        for (String serverIp : serverIps) {
            sb.append(split);
            serverIp = serverIp.replaceAll("http(s)?://", BLANK_STR);
            sb.append(serverIp.replaceAll(":", "_"));
            split = "-";
        }
        return sb.toString();
    }

    static {
        clientVersion = "unknown";
        defaultNodesPath = "serverlist";
        appKey = NacosClientProperties.PROTOTYPE.getProperty(NACOS_CLIENT_APP_KEY, BLANK_STR);
        defaultContextPath = NacosClientProperties.PROTOTYPE.getProperty(NACOS_CLIENT_CONTEXT_PATH_KEY, DEFAULT_NACOS_CLIENT_CONTEXT_PATH);
        serverPort = NacosClientProperties.PROTOTYPE.getProperty(NACOS_SERVER_PORT_KEY, DEFAULT_SERVER_PORT);
        LOGGER.info("[settings] [req-serv] nacos-server port:{}", (Object)serverPort);
        clientVersion = VersionUtils.version;
    }
}

