/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.registry.nacos;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.registry.Registry;
import com.alibaba.dubbo.registry.nacos.NacosRegistry;
import com.alibaba.dubbo.registry.support.AbstractRegistryFactory;
import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosRegistryFactory
extends AbstractRegistryFactory {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected Registry createRegistry(URL url) {
        return new NacosRegistry(url, this.buildNamingService(url));
    }

    private NamingService buildNamingService(URL url) {
        Properties nacosProperties = this.buildNacosProperties(url);
        NamingService namingService = null;
        try {
            namingService = NacosFactory.createNamingService((Properties)nacosProperties);
        }
        catch (NacosException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(e.getErrMsg(), (Throwable)e);
            }
            throw new IllegalStateException(e);
        }
        return namingService;
    }

    private Properties buildNacosProperties(URL url) {
        Properties properties = new Properties();
        this.setServerAddr(url, properties);
        this.setProperties(url, properties);
        return properties;
    }

    private void setServerAddr(URL url, Properties properties) {
        StringBuilder serverAddrBuilder = new StringBuilder(url.getHost()).append(":").append(url.getPort());
        String backup = url.getParameter("backup");
        if (backup != null) {
            serverAddrBuilder.append(",").append(backup);
        }
        String serverAddr = serverAddrBuilder.toString();
        properties.put("serverAddr", serverAddr);
    }

    private void setProperties(URL url, Properties properties) {
        this.putPropertyIfAbsent(url, properties, "namespace");
        this.putPropertyIfAbsent(url, properties, "com.alibaba.nacos.naming.log.filename");
        this.putPropertyIfAbsent(url, properties, "endpoint");
        this.putPropertyIfAbsent(url, properties, "accessKey");
        this.putPropertyIfAbsent(url, properties, "secretKey");
        this.putPropertyIfAbsent(url, properties, "clusterName");
    }

    private void putPropertyIfAbsent(URL url, Properties properties, String propertyName) {
        String propertyValue = url.getParameter(propertyName);
        if (StringUtils.isNotEmpty((String)propertyValue)) {
            properties.setProperty(propertyName, propertyValue);
        }
    }
}

