/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.spring.boot.autoconfigure.actuator;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.spring.boot.autoconfigure.actuator.endpoint.DruidDataSourceMvcEndpoint;
import com.alibaba.druid.spring.boot.autoconfigure.actuator.metadata.DruidDataSourcePoolMetadata;
import javax.sql.DataSource;
import org.springframework.boot.actuate.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadata;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.context.annotation.Bean;

public class ActuatorConfiguration {
    @Bean
    public DataSourcePoolMetadataProvider druidDataSourcePoolMetadataProvider() {
        return new DataSourcePoolMetadataProvider(){

            public DataSourcePoolMetadata getDataSourcePoolMetadata(DataSource dataSource) {
                if (dataSource instanceof DruidDataSource) {
                    return new DruidDataSourcePoolMetadata((DruidDataSource)dataSource);
                }
                return null;
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnWebApplication
    @ConditionalOnEnabledEndpoint(value="druid")
    public DruidDataSourceMvcEndpoint druidDataSourceMvcEndpoint() {
        return new DruidDataSourceMvcEndpoint();
    }
}

