/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.annotation;

import com.alibaba.nacos.common.utils.StringUtils;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

final class PropertiesUtils {
    private PropertiesUtils() {
    }

    public static Properties convertToProperties(String content) throws Exception {
        if (StringUtils.isBlank((CharSequence)content)) {
            return new Properties();
        }
        try {
            return PropertiesUtils.convertFormYamlContent(content);
        }
        catch (Exception e) {
            return PropertiesUtils.convertFormPropertiesContent(content);
        }
    }

    private static Properties convertFormPropertiesContent(String content) throws Exception {
        Properties properties = new Properties();
        properties.load(new StringReader(content));
        return properties;
    }

    private static Properties convertFormYamlContent(String content) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        Map yamlMap = (Map)yaml.load(content);
        Properties properties = new Properties();
        PropertiesUtils.flattenMap("", yamlMap, properties);
        return properties;
    }

    private static void flattenMap(String prefix, Map<String, Object> map, Properties properties) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key;
            String string = key = prefix.isEmpty() ? String.valueOf(entry.getKey()) : prefix + "." + String.valueOf(entry.getKey());
            if (entry.getValue() instanceof Map) {
                PropertiesUtils.flattenMap(key, (Map)entry.getValue(), properties);
                continue;
            }
            properties.setProperty(key, entry.getValue().toString());
        }
    }
}

