/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.annotation;

import com.alibaba.nacos.api.exception.runtime.NacosDeserializationException;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Type;

final class JsonUtils {
    static ObjectMapper mapper = new ObjectMapper();

    private JsonUtils() {
    }

    public static <T> T toObj(String json, Class<T> cls) {
        try {
            return (T)mapper.readValue(json, cls);
        }
        catch (IOException e) {
            throw new NacosDeserializationException(cls, (Throwable)e);
        }
    }

    public static <T> T toObj(String json, Type type) {
        try {
            return (T)mapper.readValue(json, TypeFactory.defaultInstance().constructType(type));
        }
        catch (IOException e) {
            throw new NacosDeserializationException(type, (Throwable)e);
        }
    }

    static {
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

