/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.nacos.dynamic.server.jsontemplate;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class ResponseTemplateParser {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("\\{\\{\\s*\\.([\\w\\$\\[\\]\\.]*)\\s*}}", 32);

    public static String parse(String rawResponse, String responseTemplate) {
        if (!StringUtils.hasText((String)responseTemplate) || "{{.}}".equals(responseTemplate.trim())) {
            return rawResponse;
        }
        if (responseTemplate.trim().startsWith("$.") || responseTemplate.trim().startsWith("$[")) {
            try {
                Object result = JsonPath.read((String)rawResponse, (String)responseTemplate.trim(), (Predicate[])new Predicate[0]);
                return result != null ? result.toString() : "";
            }
            catch (Exception result) {
                // empty catch block
            }
        }
        try {
            boolean isJson;
            Map context = null;
            boolean bl = isJson = rawResponse.trim().startsWith("{") || rawResponse.trim().startsWith("[");
            if (isJson) {
                context = (Map)objectMapper.readValue(rawResponse, Map.class);
            }
            StringBuffer sb = new StringBuffer();
            Matcher matcher = TEMPLATE_PATTERN.matcher(responseTemplate);
            while (matcher.find()) {
                String key = matcher.group(1);
                String value = key == null || key.isEmpty() ? rawResponse : (context != null && context.containsKey(key) ? String.valueOf(context.get(key)) : "");
                matcher.appendReplacement(sb, Matcher.quoteReplacement(value));
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
        catch (Exception e) {
            return rawResponse;
        }
    }
}

