/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.nacos.dynamic.server.callback;

import com.alibaba.cloud.ai.mcp.nacos.dynamic.server.definition.DynamicNacosToolDefinition;
import com.alibaba.cloud.ai.mcp.nacos.dynamic.server.jsontemplate.RequestTemplateInfo;
import com.alibaba.cloud.ai.mcp.nacos.dynamic.server.jsontemplate.RequestTemplateParser;
import com.alibaba.cloud.ai.mcp.nacos.dynamic.server.jsontemplate.ResponseTemplateParser;
import com.alibaba.cloud.ai.mcp.nacos.dynamic.server.utils.SpringBeanUtils;
import com.alibaba.cloud.ai.mcp.nacos.service.NacosMcpOperationService;
import com.alibaba.nacos.api.ai.model.mcp.McpEndpointInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerRemoteServiceConfig;
import com.alibaba.nacos.api.ai.model.mcp.McpServiceRef;
import com.alibaba.nacos.api.ai.model.mcp.McpToolMeta;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.shaded.com.google.common.collect.Maps;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.definition.ToolDefinition;
import org.springframework.http.HttpMethod;
import org.springframework.lang.NonNull;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class DynamicNacosToolCallback
implements ToolCallback {
    private static final Logger logger = LoggerFactory.getLogger(DynamicNacosToolCallback.class);
    private final DynamicNacosToolDefinition toolDefinition;
    private final NacosMcpOperationService nacosMcpOperationService;
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("\\{\\{\\s*\\.([\\w]*)\\s*\\}\\}");
    private final WebClient.Builder webClientBuilder = SpringBeanUtils.getInstance().getBean(WebClient.Builder.class);
    static ObjectMapper objectMapper = new ObjectMapper();

    public DynamicNacosToolCallback(DynamicNacosToolDefinition toolDefinition) {
        this.toolDefinition = toolDefinition;
        this.nacosMcpOperationService = SpringBeanUtils.getInstance().getBean(NacosMcpOperationService.class);
    }

    private Mono<String> processToolRequest(String configJson, Map<String, Object> args, String baseUrl) {
        try {
            Map<String, Object> processedArgs;
            JsonNode toolConfig = objectMapper.readTree(configJson);
            logger.info("[executeToolRequest] toolConfig: {}", (Object)toolConfig);
            logger.info("[processToolRequest] toolConfig: {} args: {} baseUrl: {}", new Object[]{toolConfig, args, baseUrl});
            JsonNode argsNode = toolConfig.path("args");
            if (!argsNode.isMissingNode() && argsNode.isArray() && argsNode.size() > 0) {
                processedArgs = this.processArguments(argsNode, args);
                logger.info("[processToolRequest] processedArgs from args: {}", processedArgs);
            } else if (!toolConfig.path("inputSchema").isMissingNode() && toolConfig.path("inputSchema").isObject()) {
                JsonNode properties = toolConfig.path("inputSchema").path("properties");
                if (properties.isObject()) {
                    processedArgs = new HashMap<String, Object>();
                    properties.fieldNames().forEachRemaining(field -> {
                        if (args.containsKey(field)) {
                            processedArgs.put((String)field, args.get(field));
                        }
                    });
                    logger.info("[processToolRequest] processedArgs from inputSchema: {}", processedArgs);
                } else {
                    processedArgs = args;
                    logger.info("[processToolRequest] inputSchema.properties missing, use original args: {}", processedArgs);
                }
            } else {
                processedArgs = args;
                logger.info("[processToolRequest] no args or inputSchema, use original args: {}", processedArgs);
            }
            JsonNode requestTemplate = toolConfig.path("requestTemplate");
            String url = requestTemplate.path("url").asText();
            String method = requestTemplate.path("method").asText();
            logger.info("[processToolRequest] requestTemplate: {} url: {} method: {}", new Object[]{requestTemplate, url, method});
            if (url.isEmpty() || method.isEmpty()) {
                return Mono.error((Throwable)new IllegalArgumentException("URL and method are required"));
            }
            baseUrl = baseUrl != null ? baseUrl : "http://localhost";
            WebClient client = this.webClientBuilder.baseUrl(baseUrl).build();
            return this.buildAndExecuteRequest(client, requestTemplate, toolConfig.path("responseTemplate"), processedArgs, baseUrl);
        }
        catch (Exception e) {
            logger.error("Failed to process tool request", (Throwable)e);
            return Mono.error((Throwable)e);
        }
    }

    private Map<String, Object> processArguments(JsonNode argsDefinition, Map<String, Object> providedArgs) {
        HashMap<String, Object> processedArgs = new HashMap<String, Object>();
        if (argsDefinition.isArray()) {
            for (JsonNode argDef : argsDefinition) {
                Object defaultValue;
                String name = argDef.path("name").asText();
                boolean required = argDef.path("required").asBoolean(false);
                Object object = defaultValue = argDef.has("default") ? objectMapper.convertValue((Object)argDef.path("default"), Object.class) : null;
                if (providedArgs.containsKey(name)) {
                    processedArgs.put(name, providedArgs.get(name));
                    continue;
                }
                if (defaultValue != null) {
                    processedArgs.put(name, defaultValue);
                    continue;
                }
                if (!required) continue;
                throw new IllegalArgumentException("Required argument missing: " + name);
            }
        }
        return processedArgs;
    }

    private Mono<String> buildAndExecuteRequest(WebClient client, JsonNode requestTemplate, JsonNode responseTemplate, Map<String, Object> args, String baseUrl) {
        RequestTemplateInfo info = RequestTemplateParser.parseRequestTemplate(requestTemplate);
        String url = info.url;
        String method = info.method;
        HttpMethod httpMethod = HttpMethod.valueOf((String)method);
        String processedUrl = this.processTemplateString(url, args);
        logger.info("[buildAndExecuteRequest] original url template: {} processed url: {}", (Object)url, (Object)processedUrl);
        WebClient.RequestBodySpec requestBodySpec = (WebClient.RequestBodySpec)client.method(httpMethod).uri(builder -> RequestTemplateParser.buildUri(builder, processedUrl, info, args));
        RequestTemplateParser.addHeaders(requestBodySpec, info.headers, args, this::processTemplateString);
        WebClient.RequestHeadersSpec<?> headersSpec = RequestTemplateParser.addRequestBody(requestBodySpec, info, args, this::processTemplateString, objectMapper, logger);
        String fullUrl = baseUrl.endsWith("/") && processedUrl.startsWith("/") ? baseUrl + processedUrl.substring(1) : baseUrl + processedUrl;
        logger.info("[buildAndExecuteRequest] final request: method={} url={} args={}", new Object[]{method, fullUrl, args});
        return headersSpec.retrieve().bodyToMono(String.class).doOnNext(responseBody -> logger.info("[buildAndExecuteRequest] received responseBody: {}", responseBody)).map(responseBody -> this.processResponse((String)responseBody, responseTemplate, args));
    }

    private String processResponse(String responseBody, JsonNode responseTemplate, Map<String, Object> args) {
        logger.info("[processResponse] received responseBody: {}", (Object)responseBody);
        Object result = null;
        if (!responseTemplate.isEmpty()) {
            if (responseTemplate.has("body") && !responseTemplate.path("body").asText().isEmpty()) {
                String bodyTemplate = responseTemplate.path("body").asText();
                result = ResponseTemplateParser.parse(responseBody, bodyTemplate);
                logger.info("[processResponse] ResponseTemplateParser result: {}", result);
                return result;
            }
            if (responseTemplate.has("prependBody") || responseTemplate.has("appendBody")) {
                String prependText = responseTemplate.path("prependBody").asText("");
                String appendText = responseTemplate.path("appendBody").asText("");
                result = this.processTemplateString(prependText, args) + responseBody + this.processTemplateString(appendText, args);
                logger.info("[processResponse] prepend/append result: {}", result);
                return result;
            }
        }
        result = responseBody;
        logger.info("[processResponse] default result: {}", result);
        return result;
    }

    private String processTemplateString(String template, Map<String, Object> data) {
        logger.info("[processTemplateString] template: {} data: {}", (Object)template, data);
        if (template == null || template.isEmpty()) {
            return "";
        }
        Matcher matcher = TEMPLATE_PATTERN.matcher(template);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String replacement;
            String variable = matcher.group(1);
            if ("".equals(variable) || ".".equals(variable)) {
                replacement = data != null && data.size() == 1 ? String.valueOf(data.values().iterator().next()) : (data != null && !data.isEmpty() ? data.toString() : "");
            } else {
                Object value = data != null ? data.get(variable) : null;
                replacement = value != null ? value.toString() : "";
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        String finalResult = result.toString();
        logger.info("[processTemplateString] final result: {}", (Object)finalResult);
        if (finalResult.contains("{{.}}")) {
            logger.warn("[processTemplateString] WARNING: {{.}} was not replaced in result: {}", (Object)finalResult);
        }
        return finalResult;
    }

    public ToolDefinition getToolDefinition() {
        return this.toolDefinition;
    }

    public String call(@NonNull String input) {
        return this.call(input, new ToolContext((Map)Maps.newHashMap()));
    }

    public String call(@NonNull String input, ToolContext toolContext) {
        try {
            McpServiceRef serviceRef;
            logger.info("[call] input: {} toolContext: {}", (Object)input, (Object)JacksonUtils.toJson((Object)toolContext));
            logger.info("[call] input string: {}", (Object)input);
            HashMap<String, Object> args = new HashMap();
            if (!input.isEmpty()) {
                try {
                    args = (Map)objectMapper.readValue(input, Map.class);
                    logger.info("[call] parsed args: {}", args);
                }
                catch (Exception e) {
                    logger.error("[call] Failed to parse input to args", (Throwable)e);
                }
            }
            McpServerRemoteServiceConfig remoteServerConfig = this.toolDefinition.getRemoteServerConfig();
            String protocol = this.toolDefinition.getProtocol();
            if (("http".equalsIgnoreCase(protocol) || "https".equalsIgnoreCase(protocol)) && (serviceRef = remoteServerConfig.getServiceRef()) != null) {
                McpEndpointInfo mcpEndpointInfo = this.nacosMcpOperationService.selectEndpoint(serviceRef);
                logger.info("Tool callback instance: {}", (Object)JacksonUtils.toJson((Object)mcpEndpointInfo));
                McpToolMeta toolMeta = this.toolDefinition.getToolMeta();
                String baseUrl = protocol + "://" + mcpEndpointInfo.getAddress() + ":" + mcpEndpointInfo.getPort();
                if (toolMeta != null && toolMeta.getTemplates() != null) {
                    Map templates = toolMeta.getTemplates();
                    if (templates != null && templates.containsKey("json-go-template")) {
                        Object jsonGoTemplate = templates.get("json-go-template");
                        try {
                            logger.info("[call] json-go-template: {}", (Object)objectMapper.writeValueAsString(jsonGoTemplate));
                        }
                        catch (JsonProcessingException e) {
                            logger.error("[call] Failed to serialize json-go-template", (Throwable)e);
                        }
                        try {
                            String configJson = objectMapper.writeValueAsString(jsonGoTemplate);
                            logger.info("[executeToolRequest] configJson: {} args: {} baseUrl: {}", new Object[]{configJson, args, baseUrl});
                            return (String)this.processToolRequest(configJson, args, baseUrl).block();
                        }
                        catch (Exception e) {
                            logger.error("Failed to execute tool request", (Throwable)e);
                            return "";
                        }
                    }
                } else {
                    logger.warn("[call] templates not found in toolsMeta");
                }
            }
            return "";
        }
        catch (NacosException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

