/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.a2a.registry.nacos;

import com.alibaba.cloud.ai.a2a.A2aServerProperties;
import com.alibaba.cloud.ai.a2a.registry.nacos.properties.NacosA2aProperties;
import com.alibaba.cloud.ai.a2a.registry.nacos.register.NacosA2aRegistryProperties;
import com.alibaba.cloud.ai.a2a.registry.nacos.register.NacosAgentRegistry;
import com.alibaba.cloud.ai.a2a.registry.nacos.service.NacosA2aOperationService;
import com.alibaba.cloud.ai.autoconfigure.a2a.server.A2aServerAgentCardAutoConfiguration;
import com.alibaba.cloud.ai.autoconfigure.a2a.server.A2aServerRegistryAutoConfiguration;
import com.alibaba.nacos.api.ai.A2aService;
import com.alibaba.nacos.api.ai.AiFactory;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.Properties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={A2aServerAgentCardAutoConfiguration.class, A2aServerRegistryAutoConfiguration.class})
@AutoConfiguration(after={A2aServerAgentCardAutoConfiguration.class}, before={A2aServerRegistryAutoConfiguration.class})
@EnableConfigurationProperties(value={NacosA2aProperties.class, NacosA2aRegistryProperties.class})
@ConditionalOnProperty(prefix="spring.ai.alibaba.a2a.nacos.registry", value={".enabled"}, havingValue="true", matchIfMissing=true)
public class NacosA2aRegistryAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public A2aService a2aService(NacosA2aProperties nacosA2aProperties) throws NacosException {
        return AiFactory.createAiService((Properties)nacosA2aProperties.getNacosProperties());
    }

    @Bean
    public NacosA2aOperationService nacosA2aOperationService(A2aService a2aService, NacosA2aProperties nacosA2aProperties, A2aServerProperties a2aServerProperties, NacosA2aRegistryProperties nacosA2aRegistryProperties) {
        return new NacosA2aOperationService(a2aService, nacosA2aProperties, a2aServerProperties, nacosA2aRegistryProperties);
    }

    @Bean
    public NacosAgentRegistry nacosAgentRegistry(NacosA2aOperationService nacosA2aOperationService, NacosA2aProperties nacosA2aProperties) {
        return new NacosAgentRegistry(nacosA2aOperationService, nacosA2aProperties);
    }
}

