/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.a2a.registry.nacos.properties;

import com.alibaba.nacos.common.utils.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;

@ConfigurationProperties(prefix="spring.ai.alibaba.a2a.nacos")
public class NacosA2aProperties
implements EnvironmentAware {
    public static final String PREFIX = "spring.ai.alibaba.a2a.nacos";
    public static final String DEFAULT_ADDRESS = "127.0.0.1:8848";
    private static final Pattern PATTERN = Pattern.compile("-(\\w)");
    String namespace = "public";
    String serverAddr;
    String username;
    String password;
    String accessKey;
    String secretKey;
    String endpoint;
    @JsonIgnore
    private Environment environment;

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getServerAddr() {
        return this.serverAddr;
    }

    void setServerAddr(String serverAddr) {
        this.serverAddr = serverAddr;
    }

    public Properties getNacosProperties() {
        Properties properties = new Properties();
        properties.put("namespace", Objects.toString(this.namespace, ""));
        properties.put("serverAddr", Objects.toString(this.serverAddr, ""));
        properties.put("username", Objects.toString(this.username, ""));
        properties.put("password", Objects.toString(this.password, ""));
        properties.put("accessKey", Objects.toString(this.accessKey, ""));
        properties.put("secretKey", Objects.toString(this.secretKey, ""));
        String endpoint = Objects.toString(this.endpoint, "");
        if (endpoint.contains(":")) {
            int index = endpoint.indexOf(":");
            properties.put("endpoint", endpoint.substring(0, index));
            properties.put("endpointPort", endpoint.substring(index + 1));
        } else {
            properties.put("endpoint", endpoint);
        }
        this.enrichNacosConfigProperties(properties);
        if (StringUtils.isEmpty((String)this.serverAddr) && StringUtils.isEmpty((String)this.endpoint)) {
            properties.put("serverAddr", DEFAULT_ADDRESS);
        }
        return properties;
    }

    protected void enrichNacosConfigProperties(Properties nacosConfigProperties) {
        if (this.environment == null) {
            return;
        }
        ConfigurableEnvironment env = (ConfigurableEnvironment)this.environment;
        Map<String, Object> properties = this.getSubProperties((PropertySources)env.getPropertySources(), (PropertyResolver)env, PREFIX);
        properties.forEach((k, v) -> nacosConfigProperties.putIfAbsent(this.resolveKey((String)k), String.valueOf(v)));
    }

    protected String resolveKey(String key) {
        Matcher matcher = PATTERN.matcher(key);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private Map<String, Object> getSubProperties(PropertySources propertySources, PropertyResolver propertyResolver, String prefix) {
        LinkedHashMap<String, Object> subProperties = new LinkedHashMap<String, Object>();
        for (PropertySource source : propertySources) {
            for (String name : this.getPropertyNames(source)) {
                String subName;
                if (subProperties.containsKey(name) || !name.startsWith(prefix) || subProperties.containsKey(subName = name.substring(prefix.length() + 1))) continue;
                Object value = source.getProperty(name);
                if (value instanceof String) {
                    value = propertyResolver.resolvePlaceholders((String)value);
                }
                subProperties.put(subName, value);
            }
        }
        return Collections.unmodifiableMap(subProperties);
    }

    private String[] getPropertyNames(PropertySource propertySource) {
        String[] propertyNames;
        String[] stringArray = propertyNames = propertySource instanceof EnumerablePropertySource ? ((EnumerablePropertySource)propertySource).getPropertyNames() : null;
        if (propertyNames == null) {
            return new String[0];
        }
        return propertyNames;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

