/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.a2a.registry.nacos.discovery;

import com.alibaba.cloud.ai.graph.agent.a2a.AgentCardWrapper;
import com.alibaba.nacos.common.utils.CollectionUtils;
import io.a2a.spec.AgentCard;
import io.a2a.spec.AgentInterface;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;

public class NacosAgentCardWrapper
extends AgentCardWrapper {
    private final AtomicInteger pollingIndex = new AtomicInteger(0);

    public NacosAgentCardWrapper(AgentCard agentCard) {
        super(agentCard);
        this.shuffleStartIndex();
    }

    private void shuffleStartIndex() {
        if (CollectionUtils.isNotEmpty((Collection)this.getAgentCard().additionalInterfaces())) {
            int shuffleIndex = ThreadLocalRandom.current().nextInt(this.getAgentCard().additionalInterfaces().size());
            this.pollingIndex.set(shuffleIndex);
        }
    }

    public String url() {
        if (CollectionUtils.isEmpty((Collection)this.getAgentCard().additionalInterfaces())) {
            return super.url();
        }
        List<AgentInterface> agentInterfaces = this.getAgentCard().additionalInterfaces().stream().filter(agentInterface -> this.getAgentCard().preferredTransport().equals(agentInterface.transport())).toList();
        if (CollectionUtils.isEmpty(agentInterfaces)) {
            return super.url();
        }
        if (1 == agentInterfaces.size()) {
            return agentInterfaces.get(0).url();
        }
        int index = this.pollingIndex.incrementAndGet() % agentInterfaces.size();
        return agentInterfaces.get(index).url();
    }

    public void setAgentCard(AgentCard agentCard) {
        super.setAgentCard(agentCard);
        this.shuffleStartIndex();
    }
}

