/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.a2a;

import com.alibaba.cloud.ai.a2a.utils.InetUtils;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.ai.alibaba.a2a.server")
public class A2aServerProperties
implements EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(A2aServerProperties.class);
    public static final String CONFIG_PREFIX = "spring.ai.alibaba.a2a.server";
    private String type = "JSONRPC";
    private String agentCardUrl = "/.well-known/agent.json";
    private String messageUrl = "/a2a";
    private String address;
    private Integer port;
    private String version = "1.0.0";
    private Environment environment;

    @PostConstruct
    public void init() {
        String portFromServerPort;
        if (!StringUtils.hasLength((String)this.getAddress())) {
            String addressFromServerAddress = this.environment.resolvePlaceholders("${server.address:}");
            if (StringUtils.hasLength((String)addressFromServerAddress)) {
                this.setAddress(addressFromServerAddress);
            } else {
                this.setAddress(InetUtils.findFirstNonLoopbackIpv4Address().getHostAddress());
            }
        }
        if (null == this.getPort() && StringUtils.hasLength((String)(portFromServerPort = this.environment.resolvePlaceholders("${server.port:}")))) {
            this.setPort(Integer.parseInt(portFromServerPort));
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAgentCardUrl() {
        return this.agentCardUrl;
    }

    public void setAgentCardUrl(String agentCardUrl) {
        this.agentCardUrl = agentCardUrl;
    }

    public String getMessageUrl() {
        return this.messageUrl;
    }

    public void setMessageUrl(String messageUrl) {
        this.messageUrl = messageUrl;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

