/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.v2.client.model;

import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.util.Encoder;
import com.algorand.algosdk.v2.client.common.PathResponse;
import com.algorand.algosdk.v2.client.model.Enums;
import com.algorand.algosdk.v2.client.model.StateSchema;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TransactionApplication
extends PathResponse {
    public List<Address> accounts = new ArrayList<Address>();
    @JsonProperty(value="application-args")
    public List<byte[]> applicationArgs = new ArrayList<byte[]>();
    @JsonProperty(value="application-id")
    public Long applicationId;
    public byte[] approvalProgram;
    public byte[] clearStateProgram;
    @JsonProperty(value="extra-program-pages")
    public Long extraProgramPages;
    @JsonProperty(value="foreign-apps")
    public List<Long> foreignApps = new ArrayList<Long>();
    @JsonProperty(value="foreign-assets")
    public List<Long> foreignAssets = new ArrayList<Long>();
    @JsonProperty(value="global-state-schema")
    public StateSchema globalStateSchema;
    @JsonProperty(value="local-state-schema")
    public StateSchema localStateSchema;
    @JsonProperty(value="on-completion")
    public Enums.OnCompletion onCompletion;

    @JsonProperty(value="accounts")
    public void accounts(List<String> accounts) throws NoSuchAlgorithmException {
        this.accounts = new ArrayList<Address>();
        for (String val : accounts) {
            this.accounts.add(new Address(val));
        }
    }

    @JsonProperty(value="accounts")
    public List<String> accounts() throws NoSuchAlgorithmException {
        ArrayList<String> ret = new ArrayList<String>();
        for (Address val : this.accounts) {
            ret.add(val.encodeAsString());
        }
        return ret;
    }

    @JsonIgnore
    public void applicationArgs(List<String> base64Encoded) {
        this.applicationArgs = new ArrayList<byte[]>();
        for (String val : base64Encoded) {
            this.applicationArgs.add(Encoder.decodeFromBase64(val));
        }
    }

    @JsonIgnore
    public List<String> applicationArgs() {
        ArrayList<String> ret = new ArrayList<String>();
        for (byte[] val : this.applicationArgs) {
            ret.add(Encoder.encodeToBase64(val));
        }
        return ret;
    }

    @JsonProperty(value="approval-program")
    public void approvalProgram(String base64Encoded) {
        this.approvalProgram = Encoder.decodeFromBase64(base64Encoded);
    }

    public String approvalProgram() {
        return Encoder.encodeToBase64(this.approvalProgram);
    }

    @JsonProperty(value="clear-state-program")
    public void clearStateProgram(String base64Encoded) {
        this.clearStateProgram = Encoder.decodeFromBase64(base64Encoded);
    }

    public String clearStateProgram() {
        return Encoder.encodeToBase64(this.clearStateProgram);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        TransactionApplication other = (TransactionApplication)o;
        if (!Objects.deepEquals(this.accounts, other.accounts)) {
            return false;
        }
        if (!Objects.deepEquals(this.applicationArgs, other.applicationArgs)) {
            return false;
        }
        if (!Objects.deepEquals(this.applicationId, other.applicationId)) {
            return false;
        }
        if (!Objects.deepEquals(this.approvalProgram, other.approvalProgram)) {
            return false;
        }
        if (!Objects.deepEquals(this.clearStateProgram, other.clearStateProgram)) {
            return false;
        }
        if (!Objects.deepEquals(this.extraProgramPages, other.extraProgramPages)) {
            return false;
        }
        if (!Objects.deepEquals(this.foreignApps, other.foreignApps)) {
            return false;
        }
        if (!Objects.deepEquals(this.foreignAssets, other.foreignAssets)) {
            return false;
        }
        if (!Objects.deepEquals(this.globalStateSchema, other.globalStateSchema)) {
            return false;
        }
        if (!Objects.deepEquals(this.localStateSchema, other.localStateSchema)) {
            return false;
        }
        return Objects.deepEquals((Object)this.onCompletion, (Object)other.onCompletion);
    }
}

