/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.v2.client.model;

import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.util.Encoder;
import com.algorand.algosdk.v2.client.common.PathResponse;
import com.algorand.algosdk.v2.client.model.AccountStateDelta;
import com.algorand.algosdk.v2.client.model.Enums;
import com.algorand.algosdk.v2.client.model.EvalDeltaKeyValue;
import com.algorand.algosdk.v2.client.model.TransactionApplication;
import com.algorand.algosdk.v2.client.model.TransactionAssetConfig;
import com.algorand.algosdk.v2.client.model.TransactionAssetFreeze;
import com.algorand.algosdk.v2.client.model.TransactionAssetTransfer;
import com.algorand.algosdk.v2.client.model.TransactionKeyreg;
import com.algorand.algosdk.v2.client.model.TransactionPayment;
import com.algorand.algosdk.v2.client.model.TransactionSignature;
import com.algorand.algosdk.v2.client.model.TransactionStateProof;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Transaction
extends PathResponse {
    @JsonProperty(value="application-transaction")
    public TransactionApplication applicationTransaction;
    @JsonProperty(value="asset-config-transaction")
    public TransactionAssetConfig assetConfigTransaction;
    @JsonProperty(value="asset-freeze-transaction")
    public TransactionAssetFreeze assetFreezeTransaction;
    @JsonProperty(value="asset-transfer-transaction")
    public TransactionAssetTransfer assetTransferTransaction;
    public Address authAddr;
    @JsonProperty(value="close-rewards")
    public Long closeRewards;
    @JsonProperty(value="closing-amount")
    public Long closingAmount;
    @JsonProperty(value="confirmed-round")
    public Long confirmedRound;
    @JsonProperty(value="created-application-index")
    public Long createdApplicationIndex;
    @JsonProperty(value="created-asset-index")
    public Long createdAssetIndex;
    @JsonProperty(value="fee")
    public Long fee;
    @JsonProperty(value="first-valid")
    public Long firstValid;
    public byte[] genesisHash;
    @JsonProperty(value="genesis-id")
    public String genesisId;
    @JsonProperty(value="global-state-delta")
    public List<EvalDeltaKeyValue> globalStateDelta = new ArrayList<EvalDeltaKeyValue>();
    public byte[] group;
    @JsonProperty(value="id")
    public String id;
    @JsonProperty(value="inner-txns")
    public List<Transaction> innerTxns = new ArrayList<Transaction>();
    @JsonProperty(value="intra-round-offset")
    public Long intraRoundOffset;
    @JsonProperty(value="keyreg-transaction")
    public TransactionKeyreg keyregTransaction;
    @JsonProperty(value="last-valid")
    public Long lastValid;
    public byte[] lease;
    @JsonProperty(value="local-state-delta")
    public List<AccountStateDelta> localStateDelta = new ArrayList<AccountStateDelta>();
    @JsonProperty(value="logs")
    public List<byte[]> logs = new ArrayList<byte[]>();
    public byte[] note;
    @JsonProperty(value="payment-transaction")
    public TransactionPayment paymentTransaction;
    @JsonProperty(value="receiver-rewards")
    public Long receiverRewards;
    public Address rekeyTo;
    @JsonProperty(value="round-time")
    public Long roundTime;
    @JsonProperty(value="sender")
    public String sender;
    @JsonProperty(value="sender-rewards")
    public Long senderRewards;
    @JsonProperty(value="signature")
    public TransactionSignature signature;
    @JsonProperty(value="state-proof-transaction")
    public TransactionStateProof stateProofTransaction;
    @JsonProperty(value="tx-type")
    public Enums.TxType txType;

    @JsonProperty(value="auth-addr")
    public void authAddr(String authAddr) throws NoSuchAlgorithmException {
        this.authAddr = new Address(authAddr);
    }

    @JsonProperty(value="auth-addr")
    public String authAddr() throws NoSuchAlgorithmException {
        if (this.authAddr != null) {
            return this.authAddr.encodeAsString();
        }
        return null;
    }

    @JsonProperty(value="genesis-hash")
    public void genesisHash(String base64Encoded) {
        this.genesisHash = Encoder.decodeFromBase64(base64Encoded);
    }

    public String genesisHash() {
        return Encoder.encodeToBase64(this.genesisHash);
    }

    @JsonProperty(value="group")
    public void group(String base64Encoded) {
        this.group = Encoder.decodeFromBase64(base64Encoded);
    }

    public String group() {
        return Encoder.encodeToBase64(this.group);
    }

    @JsonProperty(value="lease")
    public void lease(String base64Encoded) {
        this.lease = Encoder.decodeFromBase64(base64Encoded);
    }

    public String lease() {
        return Encoder.encodeToBase64(this.lease);
    }

    @JsonIgnore
    public void logs(List<String> base64Encoded) {
        this.logs = new ArrayList<byte[]>();
        for (String val : base64Encoded) {
            this.logs.add(Encoder.decodeFromBase64(val));
        }
    }

    @JsonIgnore
    public List<String> logs() {
        ArrayList<String> ret = new ArrayList<String>();
        for (byte[] val : this.logs) {
            ret.add(Encoder.encodeToBase64(val));
        }
        return ret;
    }

    @JsonProperty(value="note")
    public void note(String base64Encoded) {
        this.note = Encoder.decodeFromBase64(base64Encoded);
    }

    public String note() {
        return Encoder.encodeToBase64(this.note);
    }

    @JsonProperty(value="rekey-to")
    public void rekeyTo(String rekeyTo) throws NoSuchAlgorithmException {
        this.rekeyTo = new Address(rekeyTo);
    }

    @JsonProperty(value="rekey-to")
    public String rekeyTo() throws NoSuchAlgorithmException {
        if (this.rekeyTo != null) {
            return this.rekeyTo.encodeAsString();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        Transaction other = (Transaction)o;
        if (!Objects.deepEquals(this.applicationTransaction, other.applicationTransaction)) {
            return false;
        }
        if (!Objects.deepEquals(this.assetConfigTransaction, other.assetConfigTransaction)) {
            return false;
        }
        if (!Objects.deepEquals(this.assetFreezeTransaction, other.assetFreezeTransaction)) {
            return false;
        }
        if (!Objects.deepEquals(this.assetTransferTransaction, other.assetTransferTransaction)) {
            return false;
        }
        if (!Objects.deepEquals(this.authAddr, other.authAddr)) {
            return false;
        }
        if (!Objects.deepEquals(this.closeRewards, other.closeRewards)) {
            return false;
        }
        if (!Objects.deepEquals(this.closingAmount, other.closingAmount)) {
            return false;
        }
        if (!Objects.deepEquals(this.confirmedRound, other.confirmedRound)) {
            return false;
        }
        if (!Objects.deepEquals(this.createdApplicationIndex, other.createdApplicationIndex)) {
            return false;
        }
        if (!Objects.deepEquals(this.createdAssetIndex, other.createdAssetIndex)) {
            return false;
        }
        if (!Objects.deepEquals(this.fee, other.fee)) {
            return false;
        }
        if (!Objects.deepEquals(this.firstValid, other.firstValid)) {
            return false;
        }
        if (!Objects.deepEquals(this.genesisHash, other.genesisHash)) {
            return false;
        }
        if (!Objects.deepEquals(this.genesisId, other.genesisId)) {
            return false;
        }
        if (!Objects.deepEquals(this.globalStateDelta, other.globalStateDelta)) {
            return false;
        }
        if (!Objects.deepEquals(this.group, other.group)) {
            return false;
        }
        if (!Objects.deepEquals(this.id, other.id)) {
            return false;
        }
        if (!Objects.deepEquals(this.innerTxns, other.innerTxns)) {
            return false;
        }
        if (!Objects.deepEquals(this.intraRoundOffset, other.intraRoundOffset)) {
            return false;
        }
        if (!Objects.deepEquals(this.keyregTransaction, other.keyregTransaction)) {
            return false;
        }
        if (!Objects.deepEquals(this.lastValid, other.lastValid)) {
            return false;
        }
        if (!Objects.deepEquals(this.lease, other.lease)) {
            return false;
        }
        if (!Objects.deepEquals(this.localStateDelta, other.localStateDelta)) {
            return false;
        }
        if (!Objects.deepEquals(this.logs, other.logs)) {
            return false;
        }
        if (!Objects.deepEquals(this.note, other.note)) {
            return false;
        }
        if (!Objects.deepEquals(this.paymentTransaction, other.paymentTransaction)) {
            return false;
        }
        if (!Objects.deepEquals(this.receiverRewards, other.receiverRewards)) {
            return false;
        }
        if (!Objects.deepEquals(this.rekeyTo, other.rekeyTo)) {
            return false;
        }
        if (!Objects.deepEquals(this.roundTime, other.roundTime)) {
            return false;
        }
        if (!Objects.deepEquals(this.sender, other.sender)) {
            return false;
        }
        if (!Objects.deepEquals(this.senderRewards, other.senderRewards)) {
            return false;
        }
        if (!Objects.deepEquals(this.signature, other.signature)) {
            return false;
        }
        if (!Objects.deepEquals(this.stateProofTransaction, other.stateProofTransaction)) {
            return false;
        }
        return Objects.deepEquals((Object)this.txType, (Object)other.txType);
    }
}

