/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.v2.client.model;

import com.algorand.algosdk.transaction.SignedTransaction;
import com.algorand.algosdk.util.Encoder;
import com.algorand.algosdk.v2.client.common.PathResponse;
import com.algorand.algosdk.v2.client.model.AccountStateDelta;
import com.algorand.algosdk.v2.client.model.EvalDeltaKeyValue;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PendingTransactionResponse
extends PathResponse {
    @JsonProperty(value="application-index")
    public Long applicationIndex;
    @JsonProperty(value="asset-closing-amount")
    public Long assetClosingAmount;
    @JsonProperty(value="asset-index")
    public Long assetIndex;
    @JsonProperty(value="close-rewards")
    public Long closeRewards;
    @JsonProperty(value="closing-amount")
    public Long closingAmount;
    @JsonProperty(value="confirmed-round")
    public Long confirmedRound;
    @JsonProperty(value="global-state-delta")
    public List<EvalDeltaKeyValue> globalStateDelta = new ArrayList<EvalDeltaKeyValue>();
    @JsonProperty(value="inner-txns")
    public List<PendingTransactionResponse> innerTxns = new ArrayList<PendingTransactionResponse>();
    @JsonProperty(value="local-state-delta")
    public List<AccountStateDelta> localStateDelta = new ArrayList<AccountStateDelta>();
    @JsonProperty(value="logs")
    public List<byte[]> logs = new ArrayList<byte[]>();
    @JsonProperty(value="pool-error")
    public String poolError;
    @JsonProperty(value="receiver-rewards")
    public Long receiverRewards;
    @JsonProperty(value="sender-rewards")
    public Long senderRewards;
    @JsonProperty(value="txn")
    public SignedTransaction txn;

    @JsonIgnore
    public void logs(List<String> base64Encoded) {
        this.logs = new ArrayList<byte[]>();
        for (String val : base64Encoded) {
            this.logs.add(Encoder.decodeFromBase64(val));
        }
    }

    @JsonIgnore
    public List<String> logs() {
        ArrayList<String> ret = new ArrayList<String>();
        for (byte[] val : this.logs) {
            ret.add(Encoder.encodeToBase64(val));
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        PendingTransactionResponse other = (PendingTransactionResponse)o;
        if (!Objects.deepEquals(this.applicationIndex, other.applicationIndex)) {
            return false;
        }
        if (!Objects.deepEquals(this.assetClosingAmount, other.assetClosingAmount)) {
            return false;
        }
        if (!Objects.deepEquals(this.assetIndex, other.assetIndex)) {
            return false;
        }
        if (!Objects.deepEquals(this.closeRewards, other.closeRewards)) {
            return false;
        }
        if (!Objects.deepEquals(this.closingAmount, other.closingAmount)) {
            return false;
        }
        if (!Objects.deepEquals(this.confirmedRound, other.confirmedRound)) {
            return false;
        }
        if (!Objects.deepEquals(this.globalStateDelta, other.globalStateDelta)) {
            return false;
        }
        if (!Objects.deepEquals(this.innerTxns, other.innerTxns)) {
            return false;
        }
        if (!Objects.deepEquals(this.localStateDelta, other.localStateDelta)) {
            return false;
        }
        if (!Objects.deepEquals(this.logs, other.logs)) {
            return false;
        }
        if (!Objects.deepEquals(this.poolError, other.poolError)) {
            return false;
        }
        if (!Objects.deepEquals(this.receiverRewards, other.receiverRewards)) {
            return false;
        }
        if (!Objects.deepEquals(this.senderRewards, other.senderRewards)) {
            return false;
        }
        return Objects.deepEquals(this.txn, other.txn);
    }
}

