/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.v2.client.model;

import com.algorand.algosdk.util.Encoder;
import com.algorand.algosdk.v2.client.common.PathResponse;
import com.algorand.algosdk.v2.client.model.AccountStateDelta;
import com.algorand.algosdk.v2.client.model.DryrunState;
import com.algorand.algosdk.v2.client.model.EvalDeltaKeyValue;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DryrunTxnResult
extends PathResponse {
    @JsonProperty(value="app-call-messages")
    public List<String> appCallMessages = new ArrayList<String>();
    @JsonProperty(value="app-call-trace")
    public List<DryrunState> appCallTrace = new ArrayList<DryrunState>();
    @JsonProperty(value="budget-added")
    public Long budgetAdded;
    @JsonProperty(value="budget-consumed")
    public Long budgetConsumed;
    @JsonProperty(value="cost")
    public Long cost;
    @JsonProperty(value="disassembly")
    public List<String> disassembly = new ArrayList<String>();
    @JsonProperty(value="global-delta")
    public List<EvalDeltaKeyValue> globalDelta = new ArrayList<EvalDeltaKeyValue>();
    @JsonProperty(value="local-deltas")
    public List<AccountStateDelta> localDeltas = new ArrayList<AccountStateDelta>();
    @JsonProperty(value="logic-sig-disassembly")
    public List<String> logicSigDisassembly = new ArrayList<String>();
    @JsonProperty(value="logic-sig-messages")
    public List<String> logicSigMessages = new ArrayList<String>();
    @JsonProperty(value="logic-sig-trace")
    public List<DryrunState> logicSigTrace = new ArrayList<DryrunState>();
    @JsonProperty(value="logs")
    public List<byte[]> logs = new ArrayList<byte[]>();

    @JsonIgnore
    public void logs(List<String> base64Encoded) {
        this.logs = new ArrayList<byte[]>();
        for (String val : base64Encoded) {
            this.logs.add(Encoder.decodeFromBase64(val));
        }
    }

    @JsonIgnore
    public List<String> logs() {
        ArrayList<String> ret = new ArrayList<String>();
        for (byte[] val : this.logs) {
            ret.add(Encoder.encodeToBase64(val));
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        DryrunTxnResult other = (DryrunTxnResult)o;
        if (!Objects.deepEquals(this.appCallMessages, other.appCallMessages)) {
            return false;
        }
        if (!Objects.deepEquals(this.appCallTrace, other.appCallTrace)) {
            return false;
        }
        if (!Objects.deepEquals(this.budgetAdded, other.budgetAdded)) {
            return false;
        }
        if (!Objects.deepEquals(this.budgetConsumed, other.budgetConsumed)) {
            return false;
        }
        if (!Objects.deepEquals(this.cost, other.cost)) {
            return false;
        }
        if (!Objects.deepEquals(this.disassembly, other.disassembly)) {
            return false;
        }
        if (!Objects.deepEquals(this.globalDelta, other.globalDelta)) {
            return false;
        }
        if (!Objects.deepEquals(this.localDeltas, other.localDeltas)) {
            return false;
        }
        if (!Objects.deepEquals(this.logicSigDisassembly, other.logicSigDisassembly)) {
            return false;
        }
        if (!Objects.deepEquals(this.logicSigMessages, other.logicSigMessages)) {
            return false;
        }
        if (!Objects.deepEquals(this.logicSigTrace, other.logicSigTrace)) {
            return false;
        }
        return Objects.deepEquals(this.logs, other.logs);
    }
}

