/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.v2.client.model;

import com.algorand.algosdk.util.Encoder;
import com.algorand.algosdk.v2.client.common.PathResponse;
import com.algorand.algosdk.v2.client.model.BlockRewards;
import com.algorand.algosdk.v2.client.model.BlockUpgradeState;
import com.algorand.algosdk.v2.client.model.BlockUpgradeVote;
import com.algorand.algosdk.v2.client.model.ParticipationUpdates;
import com.algorand.algosdk.v2.client.model.StateProofTracking;
import com.algorand.algosdk.v2.client.model.Transaction;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Block
extends PathResponse {
    public byte[] genesisHash;
    @JsonProperty(value="genesis-id")
    public String genesisId;
    @JsonProperty(value="participation-updates")
    public ParticipationUpdates participationUpdates;
    public byte[] previousBlockHash;
    @JsonProperty(value="rewards")
    public BlockRewards rewards;
    @JsonProperty(value="round")
    public Long round;
    public byte[] seed;
    @JsonProperty(value="state-proof-tracking")
    public List<StateProofTracking> stateProofTracking = new ArrayList<StateProofTracking>();
    @JsonProperty(value="timestamp")
    public Long timestamp;
    @JsonProperty(value="transactions")
    public List<Transaction> transactions = new ArrayList<Transaction>();
    public byte[] transactionsRoot;
    public byte[] transactionsRootSha256;
    @JsonProperty(value="txn-counter")
    public Long txnCounter;
    @JsonProperty(value="upgrade-state")
    public BlockUpgradeState upgradeState;
    @JsonProperty(value="upgrade-vote")
    public BlockUpgradeVote upgradeVote;

    @JsonProperty(value="genesis-hash")
    public void genesisHash(String base64Encoded) {
        this.genesisHash = Encoder.decodeFromBase64(base64Encoded);
    }

    public String genesisHash() {
        return Encoder.encodeToBase64(this.genesisHash);
    }

    @JsonProperty(value="previous-block-hash")
    public void previousBlockHash(String base64Encoded) {
        this.previousBlockHash = Encoder.decodeFromBase64(base64Encoded);
    }

    public String previousBlockHash() {
        return Encoder.encodeToBase64(this.previousBlockHash);
    }

    @JsonProperty(value="seed")
    public void seed(String base64Encoded) {
        this.seed = Encoder.decodeFromBase64(base64Encoded);
    }

    public String seed() {
        return Encoder.encodeToBase64(this.seed);
    }

    @JsonProperty(value="transactions-root")
    public void transactionsRoot(String base64Encoded) {
        this.transactionsRoot = Encoder.decodeFromBase64(base64Encoded);
    }

    public String transactionsRoot() {
        return Encoder.encodeToBase64(this.transactionsRoot);
    }

    @JsonProperty(value="transactions-root-sha256")
    public void transactionsRootSha256(String base64Encoded) {
        this.transactionsRootSha256 = Encoder.decodeFromBase64(base64Encoded);
    }

    public String transactionsRootSha256() {
        return Encoder.encodeToBase64(this.transactionsRootSha256);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        Block other = (Block)o;
        if (!Objects.deepEquals(this.genesisHash, other.genesisHash)) {
            return false;
        }
        if (!Objects.deepEquals(this.genesisId, other.genesisId)) {
            return false;
        }
        if (!Objects.deepEquals(this.participationUpdates, other.participationUpdates)) {
            return false;
        }
        if (!Objects.deepEquals(this.previousBlockHash, other.previousBlockHash)) {
            return false;
        }
        if (!Objects.deepEquals(this.rewards, other.rewards)) {
            return false;
        }
        if (!Objects.deepEquals(this.round, other.round)) {
            return false;
        }
        if (!Objects.deepEquals(this.seed, other.seed)) {
            return false;
        }
        if (!Objects.deepEquals(this.stateProofTracking, other.stateProofTracking)) {
            return false;
        }
        if (!Objects.deepEquals(this.timestamp, other.timestamp)) {
            return false;
        }
        if (!Objects.deepEquals(this.transactions, other.transactions)) {
            return false;
        }
        if (!Objects.deepEquals(this.transactionsRoot, other.transactionsRoot)) {
            return false;
        }
        if (!Objects.deepEquals(this.transactionsRootSha256, other.transactionsRootSha256)) {
            return false;
        }
        if (!Objects.deepEquals(this.txnCounter, other.txnCounter)) {
            return false;
        }
        if (!Objects.deepEquals(this.upgradeState, other.upgradeState)) {
            return false;
        }
        return Objects.deepEquals(this.upgradeVote, other.upgradeVote);
    }
}

