/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.v2.client.model;

import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.util.Encoder;
import com.algorand.algosdk.v2.client.common.PathResponse;
import com.algorand.algosdk.v2.client.model.ApplicationStateSchema;
import com.algorand.algosdk.v2.client.model.TealKeyValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ApplicationParams
extends PathResponse {
    public byte[] approvalProgram;
    public byte[] clearStateProgram;
    public Address creator;
    @JsonProperty(value="extra-program-pages")
    public Long extraProgramPages;
    @JsonProperty(value="global-state")
    public List<TealKeyValue> globalState = new ArrayList<TealKeyValue>();
    @JsonProperty(value="global-state-schema")
    public ApplicationStateSchema globalStateSchema;
    @JsonProperty(value="local-state-schema")
    public ApplicationStateSchema localStateSchema;

    @JsonProperty(value="approval-program")
    public void approvalProgram(String base64Encoded) {
        this.approvalProgram = Encoder.decodeFromBase64(base64Encoded);
    }

    public String approvalProgram() {
        return Encoder.encodeToBase64(this.approvalProgram);
    }

    @JsonProperty(value="clear-state-program")
    public void clearStateProgram(String base64Encoded) {
        this.clearStateProgram = Encoder.decodeFromBase64(base64Encoded);
    }

    public String clearStateProgram() {
        return Encoder.encodeToBase64(this.clearStateProgram);
    }

    @JsonProperty(value="creator")
    public void creator(String creator) throws NoSuchAlgorithmException {
        this.creator = new Address(creator);
    }

    @JsonProperty(value="creator")
    public String creator() throws NoSuchAlgorithmException {
        if (this.creator != null) {
            return this.creator.encodeAsString();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        ApplicationParams other = (ApplicationParams)o;
        if (!Objects.deepEquals(this.approvalProgram, other.approvalProgram)) {
            return false;
        }
        if (!Objects.deepEquals(this.clearStateProgram, other.clearStateProgram)) {
            return false;
        }
        if (!Objects.deepEquals(this.creator, other.creator)) {
            return false;
        }
        if (!Objects.deepEquals(this.extraProgramPages, other.extraProgramPages)) {
            return false;
        }
        if (!Objects.deepEquals(this.globalState, other.globalState)) {
            return false;
        }
        if (!Objects.deepEquals(this.globalStateSchema, other.globalStateSchema)) {
            return false;
        }
        return Objects.deepEquals(this.localStateSchema, other.localStateSchema);
    }
}

