/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.v2.client.indexer;

import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.util.Encoder;
import com.algorand.algosdk.v2.client.common.Client;
import com.algorand.algosdk.v2.client.common.HttpMethod;
import com.algorand.algosdk.v2.client.common.Query;
import com.algorand.algosdk.v2.client.common.QueryData;
import com.algorand.algosdk.v2.client.common.Response;
import com.algorand.algosdk.v2.client.common.Utils;
import com.algorand.algosdk.v2.client.model.Enums;
import com.algorand.algosdk.v2.client.model.TransactionsResponse;
import java.util.Date;

public class SearchForTransactions
extends Query {
    public SearchForTransactions(Client client) {
        super(client, new HttpMethod("get"));
    }

    public SearchForTransactions address(Address address) {
        this.addQuery("address", String.valueOf(address));
        return this;
    }

    public SearchForTransactions addressRole(Enums.AddressRole addressRole) {
        this.addQuery("address-role", String.valueOf((Object)addressRole));
        return this;
    }

    public SearchForTransactions afterTime(Date afterTime) {
        this.addQuery("after-time", Utils.getDateString(afterTime));
        return this;
    }

    public SearchForTransactions applicationId(Long applicationId) {
        this.addQuery("application-id", String.valueOf(applicationId));
        return this;
    }

    public SearchForTransactions assetId(Long assetId) {
        this.addQuery("asset-id", String.valueOf(assetId));
        return this;
    }

    public SearchForTransactions beforeTime(Date beforeTime) {
        this.addQuery("before-time", Utils.getDateString(beforeTime));
        return this;
    }

    public SearchForTransactions currencyGreaterThan(Long currencyGreaterThan) {
        this.addQuery("currency-greater-than", String.valueOf(currencyGreaterThan));
        return this;
    }

    public SearchForTransactions currencyLessThan(Long currencyLessThan) {
        this.addQuery("currency-less-than", String.valueOf(currencyLessThan));
        return this;
    }

    public SearchForTransactions excludeCloseTo(Boolean excludeCloseTo) {
        this.addQuery("exclude-close-to", String.valueOf(excludeCloseTo));
        return this;
    }

    public SearchForTransactions limit(Long limit) {
        this.addQuery("limit", String.valueOf(limit));
        return this;
    }

    public SearchForTransactions maxRound(Long maxRound) {
        this.addQuery("max-round", String.valueOf(maxRound));
        return this;
    }

    public SearchForTransactions minRound(Long minRound) {
        this.addQuery("min-round", String.valueOf(minRound));
        return this;
    }

    public SearchForTransactions next(String next) {
        this.addQuery("next", String.valueOf(next));
        return this;
    }

    public SearchForTransactions notePrefix(byte[] notePrefix) {
        this.addQuery("note-prefix", Encoder.encodeToBase64(notePrefix));
        return this;
    }

    public SearchForTransactions rekeyTo(Boolean rekeyTo) {
        this.addQuery("rekey-to", String.valueOf(rekeyTo));
        return this;
    }

    public SearchForTransactions round(Long round) {
        this.addQuery("round", String.valueOf(round));
        return this;
    }

    public SearchForTransactions sigType(Enums.SigType sigType) {
        this.addQuery("sig-type", String.valueOf((Object)sigType));
        return this;
    }

    public SearchForTransactions txType(Enums.TxType txType) {
        this.addQuery("tx-type", String.valueOf((Object)txType));
        return this;
    }

    public SearchForTransactions txid(String txid) {
        this.addQuery("txid", String.valueOf(txid));
        return this;
    }

    public Response<TransactionsResponse> execute() throws Exception {
        Response<TransactionsResponse> resp = this.baseExecute();
        resp.setValueType(TransactionsResponse.class);
        return resp;
    }

    public Response<TransactionsResponse> execute(String[] headers, String[] values) throws Exception {
        Response<TransactionsResponse> resp = this.baseExecute(headers, values);
        resp.setValueType(TransactionsResponse.class);
        return resp;
    }

    @Override
    protected QueryData getRequestString() {
        this.addPathSegment(String.valueOf("v2"));
        this.addPathSegment(String.valueOf("transactions"));
        return this.qd;
    }
}

