/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.v2.client.indexer;

import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.v2.client.common.Client;
import com.algorand.algosdk.v2.client.common.HttpMethod;
import com.algorand.algosdk.v2.client.common.Query;
import com.algorand.algosdk.v2.client.common.QueryData;
import com.algorand.algosdk.v2.client.common.Response;
import com.algorand.algosdk.v2.client.model.AccountsResponse;
import com.algorand.algosdk.v2.client.model.Enums;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SearchForAccounts
extends Query {
    public SearchForAccounts(Client client) {
        super(client, new HttpMethod("get"));
    }

    public SearchForAccounts applicationId(Long applicationId) {
        this.addQuery("application-id", String.valueOf(applicationId));
        return this;
    }

    public SearchForAccounts assetId(Long assetId) {
        this.addQuery("asset-id", String.valueOf(assetId));
        return this;
    }

    public SearchForAccounts authAddr(Address authAddr) {
        this.addQuery("auth-addr", String.valueOf(authAddr));
        return this;
    }

    public SearchForAccounts currencyGreaterThan(Long currencyGreaterThan) {
        this.addQuery("currency-greater-than", String.valueOf(currencyGreaterThan));
        return this;
    }

    public SearchForAccounts currencyLessThan(Long currencyLessThan) {
        this.addQuery("currency-less-than", String.valueOf(currencyLessThan));
        return this;
    }

    public SearchForAccounts exclude(List<Enums.Exclude> exclude) {
        this.addQuery("exclude", StringUtils.join(exclude, (String)","));
        return this;
    }

    public SearchForAccounts includeAll(Boolean includeAll) {
        this.addQuery("include-all", String.valueOf(includeAll));
        return this;
    }

    public SearchForAccounts limit(Long limit) {
        this.addQuery("limit", String.valueOf(limit));
        return this;
    }

    public SearchForAccounts next(String next) {
        this.addQuery("next", String.valueOf(next));
        return this;
    }

    public SearchForAccounts round(Long round) {
        this.addQuery("round", String.valueOf(round));
        return this;
    }

    public Response<AccountsResponse> execute() throws Exception {
        Response<AccountsResponse> resp = this.baseExecute();
        resp.setValueType(AccountsResponse.class);
        return resp;
    }

    public Response<AccountsResponse> execute(String[] headers, String[] values) throws Exception {
        Response<AccountsResponse> resp = this.baseExecute(headers, values);
        resp.setValueType(AccountsResponse.class);
        return resp;
    }

    @Override
    protected QueryData getRequestString() {
        this.addPathSegment(String.valueOf("v2"));
        this.addPathSegment(String.valueOf("accounts"));
        return this.qd;
    }
}

