/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.v2.client.indexer;

import com.algorand.algosdk.v2.client.common.Client;
import com.algorand.algosdk.v2.client.common.HttpMethod;
import com.algorand.algosdk.v2.client.common.Query;
import com.algorand.algosdk.v2.client.common.QueryData;
import com.algorand.algosdk.v2.client.common.Response;
import com.algorand.algosdk.v2.client.model.Block;

public class LookupBlock
extends Query {
    private Long roundNumber;

    public LookupBlock(Client client, Long roundNumber) {
        super(client, new HttpMethod("get"));
        this.roundNumber = roundNumber;
    }

    public LookupBlock headerOnly(Boolean headerOnly) {
        this.addQuery("header-only", String.valueOf(headerOnly));
        return this;
    }

    public Response<Block> execute() throws Exception {
        Response<Block> resp = this.baseExecute();
        resp.setValueType(Block.class);
        return resp;
    }

    public Response<Block> execute(String[] headers, String[] values) throws Exception {
        Response<Block> resp = this.baseExecute(headers, values);
        resp.setValueType(Block.class);
        return resp;
    }

    @Override
    protected QueryData getRequestString() {
        if (this.roundNumber == null) {
            throw new RuntimeException("round-number is not set. It is a required parameter.");
        }
        this.addPathSegment(String.valueOf("v2"));
        this.addPathSegment(String.valueOf("blocks"));
        this.addPathSegment(String.valueOf(this.roundNumber));
        return this.qd;
    }
}

