/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.v2.client.indexer;

import com.algorand.algosdk.v2.client.common.Client;
import com.algorand.algosdk.v2.client.common.HttpMethod;
import com.algorand.algosdk.v2.client.common.Query;
import com.algorand.algosdk.v2.client.common.QueryData;
import com.algorand.algosdk.v2.client.common.Response;
import com.algorand.algosdk.v2.client.model.AssetBalancesResponse;

public class LookupAssetBalances
extends Query {
    private Long assetId;

    public LookupAssetBalances(Client client, Long assetId) {
        super(client, new HttpMethod("get"));
        this.assetId = assetId;
    }

    public LookupAssetBalances currencyGreaterThan(Long currencyGreaterThan) {
        this.addQuery("currency-greater-than", String.valueOf(currencyGreaterThan));
        return this;
    }

    public LookupAssetBalances currencyLessThan(Long currencyLessThan) {
        this.addQuery("currency-less-than", String.valueOf(currencyLessThan));
        return this;
    }

    public LookupAssetBalances includeAll(Boolean includeAll) {
        this.addQuery("include-all", String.valueOf(includeAll));
        return this;
    }

    public LookupAssetBalances limit(Long limit) {
        this.addQuery("limit", String.valueOf(limit));
        return this;
    }

    public LookupAssetBalances next(String next) {
        this.addQuery("next", String.valueOf(next));
        return this;
    }

    public Response<AssetBalancesResponse> execute() throws Exception {
        Response<AssetBalancesResponse> resp = this.baseExecute();
        resp.setValueType(AssetBalancesResponse.class);
        return resp;
    }

    public Response<AssetBalancesResponse> execute(String[] headers, String[] values) throws Exception {
        Response<AssetBalancesResponse> resp = this.baseExecute(headers, values);
        resp.setValueType(AssetBalancesResponse.class);
        return resp;
    }

    @Override
    protected QueryData getRequestString() {
        if (this.assetId == null) {
            throw new RuntimeException("asset-id is not set. It is a required parameter.");
        }
        this.addPathSegment(String.valueOf("v2"));
        this.addPathSegment(String.valueOf("assets"));
        this.addPathSegment(String.valueOf(this.assetId));
        this.addPathSegment(String.valueOf("balances"));
        return this.qd;
    }
}

