/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.v2.client.indexer;

import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.v2.client.common.Client;
import com.algorand.algosdk.v2.client.common.HttpMethod;
import com.algorand.algosdk.v2.client.common.Query;
import com.algorand.algosdk.v2.client.common.QueryData;
import com.algorand.algosdk.v2.client.common.Response;
import com.algorand.algosdk.v2.client.model.ApplicationLogsResponse;

public class LookupApplicationLogsByID
extends Query {
    private Long applicationId;

    public LookupApplicationLogsByID(Client client, Long applicationId) {
        super(client, new HttpMethod("get"));
        this.applicationId = applicationId;
    }

    public LookupApplicationLogsByID limit(Long limit) {
        this.addQuery("limit", String.valueOf(limit));
        return this;
    }

    public LookupApplicationLogsByID maxRound(Long maxRound) {
        this.addQuery("max-round", String.valueOf(maxRound));
        return this;
    }

    public LookupApplicationLogsByID minRound(Long minRound) {
        this.addQuery("min-round", String.valueOf(minRound));
        return this;
    }

    public LookupApplicationLogsByID next(String next) {
        this.addQuery("next", String.valueOf(next));
        return this;
    }

    public LookupApplicationLogsByID senderAddress(Address senderAddress) {
        this.addQuery("sender-address", String.valueOf(senderAddress));
        return this;
    }

    public LookupApplicationLogsByID txid(String txid) {
        this.addQuery("txid", String.valueOf(txid));
        return this;
    }

    public Response<ApplicationLogsResponse> execute() throws Exception {
        Response<ApplicationLogsResponse> resp = this.baseExecute();
        resp.setValueType(ApplicationLogsResponse.class);
        return resp;
    }

    public Response<ApplicationLogsResponse> execute(String[] headers, String[] values) throws Exception {
        Response<ApplicationLogsResponse> resp = this.baseExecute(headers, values);
        resp.setValueType(ApplicationLogsResponse.class);
        return resp;
    }

    @Override
    protected QueryData getRequestString() {
        if (this.applicationId == null) {
            throw new RuntimeException("application-id is not set. It is a required parameter.");
        }
        this.addPathSegment(String.valueOf("v2"));
        this.addPathSegment(String.valueOf("applications"));
        this.addPathSegment(String.valueOf(this.applicationId));
        this.addPathSegment(String.valueOf("logs"));
        return this.qd;
    }
}

