/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.v2.client.indexer;

import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.util.Encoder;
import com.algorand.algosdk.v2.client.common.Client;
import com.algorand.algosdk.v2.client.common.HttpMethod;
import com.algorand.algosdk.v2.client.common.Query;
import com.algorand.algosdk.v2.client.common.QueryData;
import com.algorand.algosdk.v2.client.common.Response;
import com.algorand.algosdk.v2.client.common.Utils;
import com.algorand.algosdk.v2.client.model.Enums;
import com.algorand.algosdk.v2.client.model.TransactionsResponse;
import java.util.Date;

public class LookupAccountTransactions
extends Query {
    private Address accountId;

    public LookupAccountTransactions(Client client, Address accountId) {
        super(client, new HttpMethod("get"));
        this.accountId = accountId;
    }

    public LookupAccountTransactions afterTime(Date afterTime) {
        this.addQuery("after-time", Utils.getDateString(afterTime));
        return this;
    }

    public LookupAccountTransactions assetId(Long assetId) {
        this.addQuery("asset-id", String.valueOf(assetId));
        return this;
    }

    public LookupAccountTransactions beforeTime(Date beforeTime) {
        this.addQuery("before-time", Utils.getDateString(beforeTime));
        return this;
    }

    public LookupAccountTransactions currencyGreaterThan(Long currencyGreaterThan) {
        this.addQuery("currency-greater-than", String.valueOf(currencyGreaterThan));
        return this;
    }

    public LookupAccountTransactions currencyLessThan(Long currencyLessThan) {
        this.addQuery("currency-less-than", String.valueOf(currencyLessThan));
        return this;
    }

    public LookupAccountTransactions limit(Long limit) {
        this.addQuery("limit", String.valueOf(limit));
        return this;
    }

    public LookupAccountTransactions maxRound(Long maxRound) {
        this.addQuery("max-round", String.valueOf(maxRound));
        return this;
    }

    public LookupAccountTransactions minRound(Long minRound) {
        this.addQuery("min-round", String.valueOf(minRound));
        return this;
    }

    public LookupAccountTransactions next(String next) {
        this.addQuery("next", String.valueOf(next));
        return this;
    }

    public LookupAccountTransactions notePrefix(byte[] notePrefix) {
        this.addQuery("note-prefix", Encoder.encodeToBase64(notePrefix));
        return this;
    }

    public LookupAccountTransactions rekeyTo(Boolean rekeyTo) {
        this.addQuery("rekey-to", String.valueOf(rekeyTo));
        return this;
    }

    public LookupAccountTransactions round(Long round) {
        this.addQuery("round", String.valueOf(round));
        return this;
    }

    public LookupAccountTransactions sigType(Enums.SigType sigType) {
        this.addQuery("sig-type", String.valueOf((Object)sigType));
        return this;
    }

    public LookupAccountTransactions txType(Enums.TxType txType) {
        this.addQuery("tx-type", String.valueOf((Object)txType));
        return this;
    }

    public LookupAccountTransactions txid(String txid) {
        this.addQuery("txid", String.valueOf(txid));
        return this;
    }

    public Response<TransactionsResponse> execute() throws Exception {
        Response<TransactionsResponse> resp = this.baseExecute();
        resp.setValueType(TransactionsResponse.class);
        return resp;
    }

    public Response<TransactionsResponse> execute(String[] headers, String[] values) throws Exception {
        Response<TransactionsResponse> resp = this.baseExecute(headers, values);
        resp.setValueType(TransactionsResponse.class);
        return resp;
    }

    @Override
    protected QueryData getRequestString() {
        if (this.accountId == null) {
            throw new RuntimeException("account-id is not set. It is a required parameter.");
        }
        this.addPathSegment(String.valueOf("v2"));
        this.addPathSegment(String.valueOf("accounts"));
        this.addPathSegment(String.valueOf(this.accountId));
        this.addPathSegment(String.valueOf("transactions"));
        return this.qd;
    }
}

