/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.v2.client.indexer;

import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.v2.client.common.Client;
import com.algorand.algosdk.v2.client.common.HttpMethod;
import com.algorand.algosdk.v2.client.common.Query;
import com.algorand.algosdk.v2.client.common.QueryData;
import com.algorand.algosdk.v2.client.common.Response;
import com.algorand.algosdk.v2.client.model.AssetsResponse;

public class LookupAccountCreatedAssets
extends Query {
    private Address accountId;

    public LookupAccountCreatedAssets(Client client, Address accountId) {
        super(client, new HttpMethod("get"));
        this.accountId = accountId;
    }

    public LookupAccountCreatedAssets assetId(Long assetId) {
        this.addQuery("asset-id", String.valueOf(assetId));
        return this;
    }

    public LookupAccountCreatedAssets includeAll(Boolean includeAll) {
        this.addQuery("include-all", String.valueOf(includeAll));
        return this;
    }

    public LookupAccountCreatedAssets limit(Long limit) {
        this.addQuery("limit", String.valueOf(limit));
        return this;
    }

    public LookupAccountCreatedAssets next(String next) {
        this.addQuery("next", String.valueOf(next));
        return this;
    }

    public Response<AssetsResponse> execute() throws Exception {
        Response<AssetsResponse> resp = this.baseExecute();
        resp.setValueType(AssetsResponse.class);
        return resp;
    }

    public Response<AssetsResponse> execute(String[] headers, String[] values) throws Exception {
        Response<AssetsResponse> resp = this.baseExecute(headers, values);
        resp.setValueType(AssetsResponse.class);
        return resp;
    }

    @Override
    protected QueryData getRequestString() {
        if (this.accountId == null) {
            throw new RuntimeException("account-id is not set. It is a required parameter.");
        }
        this.addPathSegment(String.valueOf("v2"));
        this.addPathSegment(String.valueOf("accounts"));
        this.addPathSegment(String.valueOf(this.accountId));
        this.addPathSegment(String.valueOf("created-assets"));
        return this.qd;
    }
}

