/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.v2.client.indexer;

import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.v2.client.common.Client;
import com.algorand.algosdk.v2.client.common.HttpMethod;
import com.algorand.algosdk.v2.client.common.Query;
import com.algorand.algosdk.v2.client.common.QueryData;
import com.algorand.algosdk.v2.client.common.Response;
import com.algorand.algosdk.v2.client.model.ApplicationsResponse;

public class LookupAccountCreatedApplications
extends Query {
    private Address accountId;

    public LookupAccountCreatedApplications(Client client, Address accountId) {
        super(client, new HttpMethod("get"));
        this.accountId = accountId;
    }

    public LookupAccountCreatedApplications applicationId(Long applicationId) {
        this.addQuery("application-id", String.valueOf(applicationId));
        return this;
    }

    public LookupAccountCreatedApplications includeAll(Boolean includeAll) {
        this.addQuery("include-all", String.valueOf(includeAll));
        return this;
    }

    public LookupAccountCreatedApplications limit(Long limit) {
        this.addQuery("limit", String.valueOf(limit));
        return this;
    }

    public LookupAccountCreatedApplications next(String next) {
        this.addQuery("next", String.valueOf(next));
        return this;
    }

    public Response<ApplicationsResponse> execute() throws Exception {
        Response<ApplicationsResponse> resp = this.baseExecute();
        resp.setValueType(ApplicationsResponse.class);
        return resp;
    }

    public Response<ApplicationsResponse> execute(String[] headers, String[] values) throws Exception {
        Response<ApplicationsResponse> resp = this.baseExecute(headers, values);
        resp.setValueType(ApplicationsResponse.class);
        return resp;
    }

    @Override
    protected QueryData getRequestString() {
        if (this.accountId == null) {
            throw new RuntimeException("account-id is not set. It is a required parameter.");
        }
        this.addPathSegment(String.valueOf("v2"));
        this.addPathSegment(String.valueOf("accounts"));
        this.addPathSegment(String.valueOf(this.accountId));
        this.addPathSegment(String.valueOf("created-applications"));
        return this.qd;
    }
}

