/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.v2.client.indexer;

import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.v2.client.common.Client;
import com.algorand.algosdk.v2.client.common.HttpMethod;
import com.algorand.algosdk.v2.client.common.Query;
import com.algorand.algosdk.v2.client.common.QueryData;
import com.algorand.algosdk.v2.client.common.Response;
import com.algorand.algosdk.v2.client.model.AccountResponse;
import com.algorand.algosdk.v2.client.model.Enums;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class LookupAccountByID
extends Query {
    private Address accountId;

    public LookupAccountByID(Client client, Address accountId) {
        super(client, new HttpMethod("get"));
        this.accountId = accountId;
    }

    public LookupAccountByID exclude(List<Enums.Exclude> exclude) {
        this.addQuery("exclude", StringUtils.join(exclude, (String)","));
        return this;
    }

    public LookupAccountByID includeAll(Boolean includeAll) {
        this.addQuery("include-all", String.valueOf(includeAll));
        return this;
    }

    public LookupAccountByID round(Long round) {
        this.addQuery("round", String.valueOf(round));
        return this;
    }

    public Response<AccountResponse> execute() throws Exception {
        Response<AccountResponse> resp = this.baseExecute();
        resp.setValueType(AccountResponse.class);
        return resp;
    }

    public Response<AccountResponse> execute(String[] headers, String[] values) throws Exception {
        Response<AccountResponse> resp = this.baseExecute(headers, values);
        resp.setValueType(AccountResponse.class);
        return resp;
    }

    @Override
    protected QueryData getRequestString() {
        if (this.accountId == null) {
            throw new RuntimeException("account-id is not set. It is a required parameter.");
        }
        this.addPathSegment(String.valueOf("v2"));
        this.addPathSegment(String.valueOf("accounts"));
        this.addPathSegment(String.valueOf(this.accountId));
        return this.qd;
    }
}

