/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.v2.client.indexer;

import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.v2.client.common.Client;
import com.algorand.algosdk.v2.client.common.HttpMethod;
import com.algorand.algosdk.v2.client.common.Query;
import com.algorand.algosdk.v2.client.common.QueryData;
import com.algorand.algosdk.v2.client.common.Response;
import com.algorand.algosdk.v2.client.model.ApplicationLocalStatesResponse;

public class LookupAccountAppLocalStates
extends Query {
    private Address accountId;

    public LookupAccountAppLocalStates(Client client, Address accountId) {
        super(client, new HttpMethod("get"));
        this.accountId = accountId;
    }

    public LookupAccountAppLocalStates applicationId(Long applicationId) {
        this.addQuery("application-id", String.valueOf(applicationId));
        return this;
    }

    public LookupAccountAppLocalStates includeAll(Boolean includeAll) {
        this.addQuery("include-all", String.valueOf(includeAll));
        return this;
    }

    public LookupAccountAppLocalStates limit(Long limit) {
        this.addQuery("limit", String.valueOf(limit));
        return this;
    }

    public LookupAccountAppLocalStates next(String next) {
        this.addQuery("next", String.valueOf(next));
        return this;
    }

    public Response<ApplicationLocalStatesResponse> execute() throws Exception {
        Response<ApplicationLocalStatesResponse> resp = this.baseExecute();
        resp.setValueType(ApplicationLocalStatesResponse.class);
        return resp;
    }

    public Response<ApplicationLocalStatesResponse> execute(String[] headers, String[] values) throws Exception {
        Response<ApplicationLocalStatesResponse> resp = this.baseExecute(headers, values);
        resp.setValueType(ApplicationLocalStatesResponse.class);
        return resp;
    }

    @Override
    protected QueryData getRequestString() {
        if (this.accountId == null) {
            throw new RuntimeException("account-id is not set. It is a required parameter.");
        }
        this.addPathSegment(String.valueOf("v2"));
        this.addPathSegment(String.valueOf("accounts"));
        this.addPathSegment(String.valueOf(this.accountId));
        this.addPathSegment(String.valueOf("apps-local-state"));
        return this.qd;
    }
}

