/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.v2.client.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.msgpack.jackson.dataformat.MessagePackFactory;

public class Utils {
    public static final ObjectWriter jsonWriter;
    public static final ObjectReader jsonReader;
    public static final ObjectWriter msgpWriter;
    public static final ObjectReader msgpReader;

    public static Date parseDate(String dateString) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
        if (dateString.indexOf(46) > 0) {
            sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSX");
        }
        if (dateString.indexOf(90) == -1) {
            throw new RuntimeException("The time should end with the time-zone Z");
        }
        return sdf.parse(dateString.replace("Z", "-0000"));
    }

    public static String getDateString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
        if (date.getTime() % 1000L != 0L) {
            sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSX");
        }
        sdf.setTimeZone(TimeZone.getTimeZone("Z"));
        return sdf.format(date);
    }

    static {
        ObjectMapper msgpMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());
        msgpMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        msgpMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        msgpMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        ObjectMapper jsonMapper = new ObjectMapper();
        jsonMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        jsonMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        jsonWriter = jsonMapper.writer();
        jsonReader = jsonMapper.reader();
        msgpWriter = msgpMapper.writer();
        msgpReader = msgpMapper.reader();
    }
}

