/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.v2.client.common;

import com.algorand.algosdk.util.Encoder;
import com.algorand.algosdk.v2.client.common.Utils;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;

public class Response<T> {
    private int code;
    private String failureMessage;
    private byte[] body;
    private String contentType;
    private Class valueType;

    public Response(int code, String failureMessage, String contentType, byte[] body) {
        this.code = code;
        this.failureMessage = failureMessage;
        this.body = body;
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setValueType(Class valueType) {
        this.valueType = valueType;
    }

    public String toString() {
        String jsonStr;
        try {
            jsonStr = Utils.jsonWriter.writeValueAsString(this.body());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e.getMessage());
        }
        return jsonStr;
    }

    public T body() {
        if (!this.isSuccessful()) {
            return null;
        }
        T response = null;
        try {
            if (this.contentType.contains("application/json")) {
                response = this.convertJson();
            }
            if (this.contentType.contains("application/messagepack") || this.contentType.contains("application/msgpack")) {
                response = this.convertMessagePack();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    private T convertJson() throws IOException {
        return (T)Utils.jsonReader.forType(this.valueType).readValue(this.body);
    }

    private T convertMessagePack() throws IOException {
        try {
            return (T)Utils.msgpReader.forType(this.valueType).readValue(this.body);
        }
        catch (Exception e) {
            byte[] bytes = Encoder.decodeFromBase64(new String(this.body));
            try {
                return (T)Utils.msgpReader.forType(this.valueType).readValue(bytes);
            }
            catch (Exception e2) {
                throw e;
            }
        }
    }

    public String message() {
        return this.failureMessage;
    }

    public boolean isSuccessful() {
        return this.code >= 200 && this.code < 300;
    }

    public int code() {
        return this.code;
    }
}

