/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.v2.client.common;

import com.algorand.algosdk.util.Encoder;
import com.algorand.algosdk.v2.client.common.Client;
import com.algorand.algosdk.v2.client.common.HttpMethod;
import com.algorand.algosdk.v2.client.common.QueryData;
import com.algorand.algosdk.v2.client.common.Response;
import com.fasterxml.jackson.core.JsonProcessingException;

public abstract class Query {
    private Client client;
    private HttpMethod httpMethod;
    protected QueryData qd;

    protected Query(Client client, HttpMethod httpMethod) {
        this.client = client;
        this.httpMethod = httpMethod;
        this.qd = new QueryData();
    }

    protected abstract QueryData getRequestString();

    protected <T> Response<T> baseExecute() throws Exception {
        return this.baseExecute(null, null);
    }

    protected <T> Response<T> baseExecute(String[] headers, String[] values) throws Exception {
        QueryData qData = this.getRequestString();
        com.squareup.okhttp.Response resp = this.client.executeCall(qData, this.httpMethod, headers, values);
        if (resp.isSuccessful()) {
            return new Response(resp.code(), null, resp.body().contentType().toString(), resp.body().bytes());
        }
        return new Response(resp.code(), resp.body().string(), null, null);
    }

    public String getRequestUrl() {
        return this.getRequestUrl(this.client.port, this.client.host);
    }

    public String getRequestUrl(int port, String host) {
        if (this.qd.pathSegments.size() == 0) {
            this.getRequestString();
        }
        return Client.getHttpUrl(this.qd, port, host).toString();
    }

    protected void addQuery(String key, String value) {
        this.qd.addQuery(key, value);
    }

    protected void resetPathSegment() {
        this.qd.resetPathSegments();
    }

    protected void addPathSegment(String segment) {
        this.qd.addPathSegment(segment);
    }

    protected void addToBody(byte[] content) {
        this.qd.addToBody(content);
    }

    protected void addToBody(Object content) {
        try {
            this.qd.addToBody(Encoder.encodeToMsgPack(content));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to encode object.", e);
        }
    }

    public abstract Response<?> execute() throws Exception;

    public abstract Response<?> execute(String[] var1, String[] var2) throws Exception;
}

