/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.v2.client.common;

import com.algorand.algosdk.v2.client.common.HttpMethod;
import com.algorand.algosdk.v2.client.common.QueryData;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class Client {
    protected OkHttpClient client;
    protected String host;
    protected int port;
    protected String token;
    protected String tokenKey;

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public static HttpUrl getHttpUrl(QueryData qData, int port, String host) {
        HttpUrl.Builder httpUrlBuilder = null;
        HttpUrl parsedHttpUrl = HttpUrl.parse((String)host);
        if (parsedHttpUrl != null) {
            httpUrlBuilder = parsedHttpUrl.newBuilder();
            if (HttpUrl.defaultPort((String)parsedHttpUrl.scheme()) != parsedHttpUrl.port() && parsedHttpUrl.port() != port) {
                throw new RuntimeException("Different ports were specified in the host URI and the port");
            }
        } else {
            httpUrlBuilder = new HttpUrl.Builder().scheme("http").host(host);
        }
        httpUrlBuilder.port(port);
        for (String string : qData.pathSegments) {
            httpUrlBuilder.addPathSegment(string);
        }
        for (Map.Entry entry : qData.queries.entrySet()) {
            try {
                String encodedKey = URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8.toString());
                String encodedValue = URLEncoder.encode((String)entry.getValue(), StandardCharsets.UTF_8.toString());
                httpUrlBuilder.addEncodedQueryParameter(encodedKey, encodedValue);
            }
            catch (UnsupportedEncodingException e) {
                httpUrlBuilder.addQueryParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
        HttpUrl httpUrl = httpUrlBuilder.build();
        return httpUrl;
    }

    public Client(String host, int port, String token, String tokenKey) {
        MediaType.parse((String)"application/json; charset=utf-8");
        this.host = host;
        this.port = port;
        this.token = token;
        this.client = new OkHttpClient();
        this.tokenKey = tokenKey;
    }

    public Response executeCall(QueryData qData, HttpMethod httpMethod, String[] headers, String[] values) throws Exception {
        HttpUrl httpUrl = Client.getHttpUrl(qData, this.port, this.host);
        Request.Builder reqBuilder = new Request.Builder().url(httpUrl);
        if (this.token != null) {
            reqBuilder.addHeader(this.tokenKey, this.token);
        }
        if (headers != null || values != null) {
            if (headers == null || values == null || headers.length != values.length) {
                throw new IllegalArgumentException("Header and value arrays must be the same length.");
            }
            for (int i = 0; i < headers.length; ++i) {
                reqBuilder.addHeader(headers[i], values[i]);
            }
        }
        switch (httpMethod.method()) {
            case "get": {
                reqBuilder.get();
                break;
            }
            case "post": {
                RequestBody rb = RequestBody.create((MediaType)MediaType.parse((String)"Binary data"), (byte[])(qData.bodySegments.isEmpty() ? new byte[]{} : qData.bodySegments.get(0)));
                reqBuilder.post(rb);
                reqBuilder.addHeader("Content-Type", "application/x-binary");
            }
        }
        Request request = reqBuilder.build();
        Response response = null;
        response = this.client.newCall(request).execute();
        return response;
    }
}

