/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.v2.client.common;

import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.v2.client.algod.AccountApplicationInformation;
import com.algorand.algosdk.v2.client.algod.AccountAssetInformation;
import com.algorand.algosdk.v2.client.algod.AccountInformation;
import com.algorand.algosdk.v2.client.algod.GetApplicationByID;
import com.algorand.algosdk.v2.client.algod.GetAssetByID;
import com.algorand.algosdk.v2.client.algod.GetBlock;
import com.algorand.algosdk.v2.client.algod.GetBlockHash;
import com.algorand.algosdk.v2.client.algod.GetGenesis;
import com.algorand.algosdk.v2.client.algod.GetLightBlockHeaderProof;
import com.algorand.algosdk.v2.client.algod.GetPendingTransactions;
import com.algorand.algosdk.v2.client.algod.GetPendingTransactionsByAddress;
import com.algorand.algosdk.v2.client.algod.GetStateProof;
import com.algorand.algosdk.v2.client.algod.GetStatus;
import com.algorand.algosdk.v2.client.algod.GetSupply;
import com.algorand.algosdk.v2.client.algod.GetTransactionProof;
import com.algorand.algosdk.v2.client.algod.GetVersion;
import com.algorand.algosdk.v2.client.algod.HealthCheck;
import com.algorand.algosdk.v2.client.algod.Metrics;
import com.algorand.algosdk.v2.client.algod.PendingTransactionInformation;
import com.algorand.algosdk.v2.client.algod.RawTransaction;
import com.algorand.algosdk.v2.client.algod.SwaggerJSON;
import com.algorand.algosdk.v2.client.algod.TealCompile;
import com.algorand.algosdk.v2.client.algod.TealDisassemble;
import com.algorand.algosdk.v2.client.algod.TealDryrun;
import com.algorand.algosdk.v2.client.algod.TransactionParams;
import com.algorand.algosdk.v2.client.algod.WaitForBlock;
import com.algorand.algosdk.v2.client.common.Client;

public class AlgodClient
extends Client {
    public AlgodClient(String host, int port, String token) {
        super(host, port, token, "X-Algo-API-Token");
    }

    public AlgodClient(String host, int port, String token, String tokenKey) {
        super(host, port, token, tokenKey);
    }

    public HealthCheck HealthCheck() {
        return new HealthCheck(this);
    }

    public Metrics Metrics() {
        return new Metrics(this);
    }

    public GetGenesis GetGenesis() {
        return new GetGenesis(this);
    }

    public SwaggerJSON SwaggerJSON() {
        return new SwaggerJSON(this);
    }

    public GetVersion GetVersion() {
        return new GetVersion(this);
    }

    public AccountInformation AccountInformation(Address address) {
        return new AccountInformation((Client)this, address);
    }

    public AccountAssetInformation AccountAssetInformation(Address address, Long assetId) {
        return new AccountAssetInformation(this, address, assetId);
    }

    public AccountApplicationInformation AccountApplicationInformation(Address address, Long applicationId) {
        return new AccountApplicationInformation(this, address, applicationId);
    }

    public GetPendingTransactionsByAddress GetPendingTransactionsByAddress(Address address) {
        return new GetPendingTransactionsByAddress((Client)this, address);
    }

    public GetBlock GetBlock(Long round) {
        return new GetBlock((Client)this, round);
    }

    public GetBlockHash GetBlockHash(Long round) {
        return new GetBlockHash((Client)this, round);
    }

    public GetTransactionProof GetTransactionProof(Long round, String txid) {
        return new GetTransactionProof(this, round, txid);
    }

    public GetSupply GetSupply() {
        return new GetSupply(this);
    }

    public GetStatus GetStatus() {
        return new GetStatus(this);
    }

    public WaitForBlock WaitForBlock(Long round) {
        return new WaitForBlock((Client)this, round);
    }

    public RawTransaction RawTransaction() {
        return new RawTransaction(this);
    }

    public TransactionParams TransactionParams() {
        return new TransactionParams(this);
    }

    public GetPendingTransactions GetPendingTransactions() {
        return new GetPendingTransactions(this);
    }

    public PendingTransactionInformation PendingTransactionInformation(String txid) {
        return new PendingTransactionInformation((Client)this, txid);
    }

    public GetStateProof GetStateProof(Long round) {
        return new GetStateProof((Client)this, round);
    }

    public GetLightBlockHeaderProof GetLightBlockHeaderProof(Long round) {
        return new GetLightBlockHeaderProof((Client)this, round);
    }

    public GetApplicationByID GetApplicationByID(Long applicationId) {
        return new GetApplicationByID((Client)this, applicationId);
    }

    public GetAssetByID GetAssetByID(Long assetId) {
        return new GetAssetByID((Client)this, assetId);
    }

    public TealCompile TealCompile() {
        return new TealCompile(this);
    }

    public TealDisassemble TealDisassemble() {
        return new TealDisassemble(this);
    }

    public TealDryrun TealDryrun() {
        return new TealDryrun(this);
    }
}

