/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.v2.client;

import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.transaction.SignedTransaction;
import com.algorand.algosdk.transaction.Transaction;
import com.algorand.algosdk.util.Encoder;
import com.algorand.algosdk.v2.client.common.AlgodClient;
import com.algorand.algosdk.v2.client.common.PathResponse;
import com.algorand.algosdk.v2.client.common.Response;
import com.algorand.algosdk.v2.client.model.Account;
import com.algorand.algosdk.v2.client.model.Application;
import com.algorand.algosdk.v2.client.model.ApplicationParams;
import com.algorand.algosdk.v2.client.model.ApplicationStateSchema;
import com.algorand.algosdk.v2.client.model.Asset;
import com.algorand.algosdk.v2.client.model.DryrunRequest;
import com.algorand.algosdk.v2.client.model.DryrunState;
import com.algorand.algosdk.v2.client.model.DryrunTxnResult;
import com.algorand.algosdk.v2.client.model.NodeStatusResponse;
import com.algorand.algosdk.v2.client.model.PendingTransactionResponse;
import com.algorand.algosdk.v2.client.model.TealValue;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Utils {
    private static final Long defaultAppId = 1380011588L;
    private static final int defaultMaxWidth = 30;

    public static DryrunRequest createDryrun(AlgodClient client, List<SignedTransaction> txns) throws Exception {
        return Utils.createDryrun(client, txns, "", 0L, 0L);
    }

    public static DryrunRequest createDryrun(AlgodClient client, List<SignedTransaction> txns, String protocol_version, Long latest_timestamp, Long round) throws Exception {
        Response<PathResponse> ar;
        if (client == null || txns.size() == 0) {
            throw new IllegalArgumentException("Bad arguments for createDryrun.");
        }
        ArrayList<Application> app_infos = new ArrayList<Application>();
        ArrayList<Account> acct_infos = new ArrayList<Account>();
        HashSet<Long> apps = new HashSet<Long>();
        HashSet<Long> assets = new HashSet<Long>();
        HashSet<String> accts = new HashSet<String>();
        for (SignedTransaction txn : txns) {
            Transaction tx = txn.tx;
            if (tx.type != Transaction.Type.ApplicationCall) continue;
            if (tx.applicationId == 0L || tx.applicationId == null) {
                Iterator<Address> params = new ApplicationParams();
                ((ApplicationParams)((Object)params)).creator = tx.sender;
                ((ApplicationParams)((Object)params)).approvalProgram = tx.approvalProgram.getBytes();
                ((ApplicationParams)((Object)params)).clearStateProgram = tx.clearStateProgram.getBytes();
                ApplicationStateSchema localState = new ApplicationStateSchema();
                localState.numByteSlice = tx.localStateSchema.numByteSlice.longValue();
                localState.numUint = tx.localStateSchema.numUint.longValue();
                ((ApplicationParams)((Object)params)).localStateSchema = localState;
                ApplicationStateSchema globalState = new ApplicationStateSchema();
                globalState.numByteSlice = tx.globalStateSchema.numByteSlice.longValue();
                globalState.numUint = tx.globalStateSchema.numUint.longValue();
                ((ApplicationParams)((Object)params)).globalStateSchema = globalState;
                Application app = new Application();
                app.id = defaultAppId;
                app.params = params;
                app_infos.add(app);
            } else {
                apps.add(tx.applicationId);
                accts.add(Address.forApplication(tx.applicationId).toString());
            }
            if (tx.foreignApps.size() > 0) {
                apps.addAll(tx.foreignApps);
                for (Long aidx : tx.foreignApps) {
                    accts.add(Address.forApplication(aidx).toString());
                }
            }
            if (tx.foreignAssets.size() > 0) {
                assets.addAll(tx.foreignAssets);
            }
            if (tx.accounts.size() <= 0) continue;
            for (Address acct : tx.accounts) {
                accts.add(acct.toString());
            }
        }
        for (Long asset : assets) {
            ar = client.GetAssetByID(asset).execute();
            if (!ar.isSuccessful()) continue;
            Asset a = ar.body();
            accts.add(a.params.creator);
        }
        for (Long app : apps) {
            ar = client.GetApplicationByID(app).execute();
            if (!ar.isSuccessful()) continue;
            app_infos.add((Application)ar.body());
            accts.add(((Application)ar.body()).params.creator.toString());
        }
        for (String acct : accts) {
            ar = client.AccountInformation(new Address(acct)).execute();
            if (!ar.isSuccessful()) continue;
            acct_infos.add((Account)ar.body());
        }
        DryrunRequest drr = new DryrunRequest();
        drr.accounts = acct_infos;
        drr.apps = app_infos;
        drr.txns = txns;
        drr.protocolVersion = protocol_version;
        drr.latestTimestamp = latest_timestamp;
        drr.round = BigInteger.valueOf(round);
        return drr;
    }

    private static String truncate(String s, int maxWidth) {
        if (s.length() > maxWidth && maxWidth > 0) {
            return s.substring(0, maxWidth) + "...";
        }
        return s;
    }

    private static String stackToString(List<TealValue> stack, boolean reverse) {
        if (reverse) {
            Collections.reverse(stack);
        }
        ArrayList<String> elems = new ArrayList<String>();
        block4: for (int i = 0; i < stack.size(); ++i) {
            TealValue tv = stack.get(i);
            switch (tv.type.intValue()) {
                case 1: {
                    byte[] decoded = Encoder.decodeFromBase64(tv.bytes);
                    elems.add("0x" + Encoder.encodeToHexStr(decoded));
                    continue block4;
                }
                case 2: {
                    elems.add(tv.uint.toString());
                    continue block4;
                }
            }
        }
        return String.format("[%s]", StringUtils.join(elems, (String)", "));
    }

    private static String scratchToString(List<TealValue> prevScratch, List<TealValue> currScratch) {
        if (currScratch.size() == 0) {
            return "";
        }
        int newIdx = -1;
        for (int i = 0; i < currScratch.size(); ++i) {
            if (i >= prevScratch.size()) {
                newIdx = i;
                continue;
            }
            if (Objects.deepEquals(prevScratch.get(i), currScratch.get(i))) continue;
            newIdx = i;
        }
        if (newIdx < 0) {
            return "";
        }
        TealValue tv = currScratch.get(newIdx);
        if (tv.bytes.length() > 0) {
            byte[] decoded = Encoder.decodeFromBase64(tv.bytes);
            String newValue = "0x" + Encoder.encodeToHexStr(decoded);
            return String.format("%d = %s", newIdx, newValue);
        }
        return String.format("%d = %d", newIdx, tv.uint);
    }

    private static String trace(List<DryrunState> state, List<String> disassembly, StackPrinterConfig spc) {
        ArrayList<String[]> lines = new ArrayList<String[]>();
        lines.add(new String[]{"pc#", "ln#", "source", "scratch", "stack"});
        for (int i = 0; i < state.size(); ++i) {
            DryrunState s = state.get(i);
            boolean hasError = s.error != null && s.error != "";
            String src = hasError ? String.format("!! %s !!", s.error) : disassembly.get(s.line.intValue());
            List<TealValue> currScratch = s.scratch;
            ArrayList<TealValue> prevScratch = i > 0 ? state.get((int)(i - 1)).scratch : new ArrayList<TealValue>();
            lines.add(new String[]{String.format("%-3d", s.pc), String.format("%-3d", s.line), Utils.truncate(src, spc.maxValueWidth), Utils.truncate(Utils.scratchToString(prevScratch, currScratch), spc.maxValueWidth), Utils.truncate(Utils.stackToString(s.stack, spc.topOfStackFirst), spc.maxValueWidth)});
        }
        int columns = ((String[])lines.get(0)).length;
        int[] maxLengths = new int[columns];
        for (int i = 0; i < lines.size(); ++i) {
            String[] line = (String[])lines.get(i);
            for (int j = 0; j < columns; ++j) {
                if (line[j].length() <= maxLengths[j]) continue;
                maxLengths[j] = line[j].length();
            }
        }
        ArrayList<String> fmts = new ArrayList<String>();
        for (int i = 0; i < columns; ++i) {
            fmts.add(String.format("%%-%ds", maxLengths[i] + 1));
        }
        String fmt = StringUtils.join(fmts, (String)"|");
        StringBuilder sb = new StringBuilder();
        for (Object[] objectArray : lines) {
            sb.append(String.format(fmt, objectArray).trim() + "\n");
        }
        return sb.toString();
    }

    public static String appTrace(DryrunTxnResult dtr) {
        StackPrinterConfig spc = new StackPrinterConfig();
        spc.maxValueWidth = 30;
        spc.topOfStackFirst = true;
        return Utils.trace(dtr.appCallTrace, dtr.disassembly, spc);
    }

    public static String appTrace(DryrunTxnResult dtr, StackPrinterConfig spc) {
        return Utils.trace(dtr.appCallTrace, dtr.disassembly, spc);
    }

    public static String lsigTrace(DryrunTxnResult dtr) {
        StackPrinterConfig spc = new StackPrinterConfig();
        spc.maxValueWidth = 30;
        spc.topOfStackFirst = true;
        return Utils.trace(dtr.logicSigTrace, dtr.logicSigDisassembly, spc);
    }

    public static String lsigTrace(DryrunTxnResult dtr, StackPrinterConfig spc) {
        return Utils.trace(dtr.logicSigTrace, dtr.logicSigDisassembly, spc);
    }

    public static PendingTransactionResponse waitForConfirmation(AlgodClient client, String txID, int waitRounds) throws Exception {
        long startRound;
        if (client == null || txID == null || waitRounds < 0) {
            throw new IllegalArgumentException("Bad arguments for waitForConfirmation.");
        }
        Response<NodeStatusResponse> resp = client.GetStatus().execute();
        if (!resp.isSuccessful()) {
            throw new Exception(resp.message());
        }
        NodeStatusResponse nodeStatusResponse = resp.body();
        for (long currentRound = startRound = nodeStatusResponse.lastRound + 1L; currentRound < startRound + (long)waitRounds; ++currentRound) {
            PendingTransactionResponse pendingInfo;
            Response<PendingTransactionResponse> resp2 = client.PendingTransactionInformation(txID).execute();
            if (resp2.isSuccessful() && (pendingInfo = resp2.body()) != null) {
                if (pendingInfo.confirmedRound != null && pendingInfo.confirmedRound > 0L) {
                    return pendingInfo;
                }
                if (pendingInfo.poolError != null && pendingInfo.poolError.length() > 0) {
                    throw new Exception("The transaction has been rejected with a pool error: " + pendingInfo.poolError);
                }
            }
            if ((resp = client.WaitForBlock(currentRound).execute()).isSuccessful()) continue;
            throw new Exception(resp.message());
        }
        throw new Exception("Transaction not confirmed after " + waitRounds + " rounds!");
    }

    public static class StackPrinterConfig {
        public int maxValueWidth = 0;
        public boolean topOfStackFirst = false;
    }
}

