/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.msgpack.jackson.dataformat.MessagePackFactory;

public class Encoder {
    private static final char BASE32_PAD_CHAR = '=';
    private static final ObjectMapper jsonMapper;
    private static final ObjectMapper msgpMapper;
    private static final ObjectMapper basicMapper;
    public static final int UINT64_LENGTH = 8;
    public static final BigInteger MAX_UINT64;

    public static byte[] encodeToMsgPack(Object o) throws JsonProcessingException {
        return msgpMapper.writeValueAsBytes(o);
    }

    public static <T> T decodeFromMsgPack(String input, Class<T> tClass) throws IOException {
        return Encoder.decodeFromMsgPack(Encoder.decodeFromBase64(input), tClass);
    }

    public static <T> T decodeFromMsgPack(byte[] input, Class<T> tClass) throws IOException {
        return (T)msgpMapper.readValue(input, tClass);
    }

    public static String encodeToJson(Object o) throws JsonProcessingException {
        return jsonMapper.writeValueAsString(o);
    }

    public static <T> T decodeFromJson(String input, Class<T> tClass) throws IOException {
        return (T)basicMapper.readerFor(tClass).readValue(input);
    }

    public static String encodeToHexStr(byte[] bytes) {
        return Hex.encodeHexString((byte[])bytes);
    }

    public static byte[] decodeFromHexStr(String hexStr) throws DecoderException {
        return Hex.decodeHex((String)hexStr);
    }

    public static String encodeToBase32StripPad(byte[] bytes) {
        Base32 codec = new Base32(61);
        String paddedStr = codec.encodeToString(bytes);
        return StringUtils.stripEnd((String)paddedStr, (String)String.valueOf('='));
    }

    public static byte[] decodeFromBase32StripPad(String base32) {
        Base32 codec = new Base32(61);
        return codec.decode(base32);
    }

    public static String encodeToBase64(byte[] bytes) {
        Base64 codec = new Base64();
        return codec.encodeToString(bytes);
    }

    public static byte[] decodeFromBase64(String str) {
        Base64 codec = new Base64();
        return codec.decode(str);
    }

    public static byte[] encodeUint64(BigInteger value) {
        return Encoder.encodeUintToBytes(value, 8);
    }

    public static byte[] encodeUint64(long value) {
        return Encoder.encodeUintToBytes(BigInteger.valueOf(value), 8);
    }

    public static BigInteger decodeUint64(byte[] encoded) {
        if (encoded.length > 8) {
            throw new IllegalArgumentException("Length of byte array is invalid");
        }
        return new BigInteger(1, encoded);
    }

    public static byte[] encodeUintToBytes(BigInteger value, int byteNum) {
        if (value.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("Encode int to byte: input BigInteger < 0");
        }
        if (value.compareTo(BigInteger.ONE.shiftLeft(byteNum * 8)) >= 0) {
            throw new IllegalArgumentException("Encode int to byte: integer size exceeds the given byte number");
        }
        byte[] buffer = new byte[byteNum];
        byte[] encoded = value.toByteArray();
        if (encoded.length == byteNum + 1) {
            encoded = Arrays.copyOfRange(encoded, 1, encoded.length);
        }
        System.arraycopy(encoded, 0, buffer, buffer.length - encoded.length, encoded.length);
        return buffer;
    }

    public static BigInteger decodeBytesToUint(byte[] encoded) {
        return new BigInteger(1, encoded);
    }

    static {
        basicMapper = new ObjectMapper();
        MAX_UINT64 = new BigInteger("FFFFFFFFFFFFFFFF", 16);
        msgpMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());
        msgpMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        msgpMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        msgpMapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        jsonMapper = new ObjectMapper();
        jsonMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        jsonMapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
    }
}

