/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.transaction;

import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.crypto.Digest;
import com.algorand.algosdk.transaction.Transaction;
import com.algorand.algosdk.util.Digester;
import com.algorand.algosdk.util.Encoder;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;

@JsonPropertyOrder(alphabetic=true)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class TxGroup
implements Serializable {
    private static final byte[] TG_PREFIX = "TG".getBytes(StandardCharsets.UTF_8);
    public static int MAX_TX_GROUP_SIZE = 16;
    @JsonProperty(value="txlist")
    private Digest[] txGroupHashes;

    public static Digest computeGroupID(Transaction ... txns) throws IOException, IllegalArgumentException {
        if (txns == null || txns.length == 0) {
            throw new IllegalArgumentException("empty transaction list");
        }
        if (txns.length > MAX_TX_GROUP_SIZE) {
            throw new IllegalArgumentException("max group size is " + MAX_TX_GROUP_SIZE);
        }
        Digest[] txIDs = new Digest[txns.length];
        for (int i = 0; i < txns.length; ++i) {
            txIDs[i] = txns[i].rawTxID();
        }
        TxGroup txgroup = new TxGroup(txIDs);
        try {
            byte[] gid = Digester.digest(txgroup.bytesToSign());
            return new Digest(gid);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("tx computation failed", e);
        }
    }

    public static Transaction[] assignGroupID(Transaction ... txns) throws IOException {
        return TxGroup.assignGroupID(txns, null);
    }

    public static Transaction[] assignGroupID(Address address, Transaction ... txns) throws IOException {
        return TxGroup.assignGroupID(txns, address);
    }

    @Deprecated
    public static Transaction[] assignGroupID(Transaction[] txns, Address address) throws IOException {
        Digest gid = TxGroup.computeGroupID(txns);
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        for (Transaction tx : txns) {
            if (address != null && address.toString() != "" && address != tx.sender) continue;
            tx.assignGroupID(gid);
            result.add(tx);
        }
        return result.toArray(new Transaction[result.size()]);
    }

    @JsonCreator
    private TxGroup(@JsonProperty(value="txlist") Digest[] txGroupHashes) {
        this.txGroupHashes = txGroupHashes;
    }

    private byte[] bytesToSign() throws IOException {
        try {
            byte[] encodedTx = Encoder.encodeToMsgPack(this);
            byte[] prefixEncodedTx = Arrays.copyOf(TG_PREFIX, TG_PREFIX.length + encodedTx.length);
            System.arraycopy(encodedTx, 0, prefixEncodedTx, TG_PREFIX.length, encodedTx.length);
            return prefixEncodedTx;
        }
        catch (IOException e) {
            throw new RuntimeException("serialization failed", e);
        }
    }
}

