/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.transaction;

import com.algorand.algosdk.account.Account;
import com.algorand.algosdk.builder.transaction.ApplicationCallTransactionBuilder;
import com.algorand.algosdk.builder.transaction.ApplicationClearTransactionBuilder;
import com.algorand.algosdk.builder.transaction.ApplicationCloseTransactionBuilder;
import com.algorand.algosdk.builder.transaction.ApplicationCreateTransactionBuilder;
import com.algorand.algosdk.builder.transaction.ApplicationDeleteTransactionBuilder;
import com.algorand.algosdk.builder.transaction.ApplicationOptInTransactionBuilder;
import com.algorand.algosdk.builder.transaction.ApplicationUpdateTransactionBuilder;
import com.algorand.algosdk.builder.transaction.AssetAcceptTransactionBuilder;
import com.algorand.algosdk.builder.transaction.AssetClawbackTransactionBuilder;
import com.algorand.algosdk.builder.transaction.AssetConfigureTransactionBuilder;
import com.algorand.algosdk.builder.transaction.AssetCreateTransactionBuilder;
import com.algorand.algosdk.builder.transaction.AssetDestroyTransactionBuilder;
import com.algorand.algosdk.builder.transaction.AssetFreezeTransactionBuilder;
import com.algorand.algosdk.builder.transaction.AssetTransferTransactionBuilder;
import com.algorand.algosdk.builder.transaction.KeyRegistrationTransactionBuilder;
import com.algorand.algosdk.builder.transaction.PaymentTransactionBuilder;
import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.crypto.Digest;
import com.algorand.algosdk.crypto.MerkleVerifier;
import com.algorand.algosdk.crypto.ParticipationPublicKey;
import com.algorand.algosdk.crypto.TEALProgram;
import com.algorand.algosdk.crypto.VRFPublicKey;
import com.algorand.algosdk.logic.StateSchema;
import com.algorand.algosdk.transaction.AssetParams;
import com.algorand.algosdk.transaction.Lease;
import com.algorand.algosdk.util.Digester;
import com.algorand.algosdk.util.Encoder;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(alphabetic=true)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class Transaction
implements Serializable {
    private static final byte[] TX_SIGN_PREFIX = "TX".getBytes(StandardCharsets.UTF_8);
    @JsonProperty(value="type")
    public Type type = Type.Default;
    @JsonProperty(value="snd")
    public Address sender = new Address();
    @JsonProperty(value="fee")
    public BigInteger fee = BigInteger.ZERO;
    @JsonProperty(value="fv")
    public BigInteger firstValid = BigInteger.valueOf(0L);
    @JsonProperty(value="lv")
    public BigInteger lastValid = BigInteger.valueOf(0L);
    @JsonProperty(value="note")
    public byte[] note;
    @JsonProperty(value="gen")
    public String genesisID = "";
    @JsonProperty(value="gh")
    public Digest genesisHash = new Digest();
    @JsonProperty(value="grp")
    public Digest group = new Digest();
    @JsonProperty(value="lx")
    public byte[] lease;
    @JsonProperty(value="rekey")
    public Address rekeyTo = new Address();
    @JsonProperty(value="amt")
    public BigInteger amount = BigInteger.valueOf(0L);
    @JsonProperty(value="rcv")
    public Address receiver = new Address();
    @JsonProperty(value="close")
    public Address closeRemainderTo = new Address();
    @JsonProperty(value="votekey")
    public ParticipationPublicKey votePK = new ParticipationPublicKey();
    @JsonProperty(value="selkey")
    public VRFPublicKey selectionPK = new VRFPublicKey();
    @JsonProperty(value="sprfkey")
    public MerkleVerifier stateProofKey = new MerkleVerifier();
    @JsonProperty(value="nonpart")
    public boolean nonpart = false;
    @JsonProperty(value="votefst")
    public BigInteger voteFirst = BigInteger.valueOf(0L);
    @JsonProperty(value="votelst")
    public BigInteger voteLast = BigInteger.valueOf(0L);
    @JsonProperty(value="votekd")
    public BigInteger voteKeyDilution = BigInteger.valueOf(0L);
    @JsonProperty(value="apar")
    public AssetParams assetParams = new AssetParams();
    @JsonProperty(value="caid")
    public BigInteger assetIndex = BigInteger.valueOf(0L);
    @JsonProperty(value="xaid")
    public BigInteger xferAsset = BigInteger.valueOf(0L);
    @JsonProperty(value="aamt")
    public BigInteger assetAmount = BigInteger.valueOf(0L);
    @JsonProperty(value="asnd")
    public Address assetSender = new Address();
    @JsonProperty(value="arcv")
    public Address assetReceiver = new Address();
    @JsonProperty(value="aclose")
    public Address assetCloseTo = new Address();
    @JsonProperty(value="fadd")
    public Address freezeTarget = new Address();
    @JsonProperty(value="faid")
    public BigInteger assetFreezeID = BigInteger.valueOf(0L);
    @JsonProperty(value="afrz")
    public boolean freezeState = false;
    @JsonProperty(value="apaa")
    public List<byte[]> applicationArgs = new ArrayList<byte[]>();
    @JsonProperty(value="apan")
    public OnCompletion onCompletion = OnCompletion.NoOpOC;
    @JsonProperty(value="apap")
    public TEALProgram approvalProgram = null;
    @JsonProperty(value="apat")
    public List<Address> accounts = new ArrayList<Address>();
    @JsonProperty(value="apfa")
    public List<Long> foreignApps = new ArrayList<Long>();
    @JsonProperty(value="apas")
    public List<Long> foreignAssets = new ArrayList<Long>();
    @JsonProperty(value="apgs")
    public StateSchema globalStateSchema = new StateSchema();
    @JsonProperty(value="apid")
    public Long applicationId = 0L;
    @JsonProperty(value="apls")
    public StateSchema localStateSchema = new StateSchema();
    @JsonProperty(value="apsu")
    public TEALProgram clearStateProgram = null;
    @JsonProperty(value="apep")
    public Long extraPages = 0L;
    @JsonProperty(value="sptype")
    public Integer stateProofType = null;
    @JsonProperty(value="sp")
    public Map<String, Object> stateProof = null;
    @JsonProperty(value="spmsg")
    public Map<String, Object> stateProofMessage = null;

    @Deprecated
    public Transaction(Address fromAddr, Address toAddr, BigInteger fee, BigInteger amount, BigInteger firstRound, BigInteger lastRound) {
        this(fromAddr, fee, firstRound, lastRound, null, amount, toAddr, "", new Digest());
    }

    @Deprecated
    public Transaction(Address fromAddr, Address toAddr, BigInteger fee, BigInteger amount, BigInteger firstRound, BigInteger lastRound, String genesisID, Digest genesisHash) {
        this(fromAddr, fee, firstRound, lastRound, null, amount, toAddr, genesisID, genesisHash);
    }

    @Deprecated
    public Transaction(Address fromAddr, Address toAddr, long amount, long firstRound, long lastRound, String genesisID, Digest genesisHash) {
        this(fromAddr, Account.MIN_TX_FEE_UALGOS, BigInteger.valueOf(firstRound), BigInteger.valueOf(lastRound), null, BigInteger.valueOf(amount), toAddr, genesisID, genesisHash);
    }

    @Deprecated
    public Transaction(Address sender, BigInteger fee, BigInteger firstValid, BigInteger lastValid, byte[] note, BigInteger amount, Address receiver, String genesisID, Digest genesisHash) {
        this(sender, fee, firstValid, lastValid, note, genesisID, genesisHash, amount, receiver, new Address());
    }

    @Deprecated
    public Transaction(Address sender, BigInteger fee, BigInteger firstValid, BigInteger lastValid, byte[] note, String genesisID, Digest genesisHash, BigInteger amount, Address receiver, Address closeRemainderTo) {
        this.type = Type.Payment;
        if (sender != null) {
            this.sender = sender;
        }
        this.setFee(fee);
        if (firstValid != null) {
            this.firstValid = firstValid;
        }
        if (lastValid != null) {
            this.lastValid = lastValid;
        }
        this.setNote(note);
        if (genesisID != null) {
            this.genesisID = genesisID;
        }
        if (genesisHash != null) {
            this.genesisHash = genesisHash;
        }
        if (amount != null) {
            this.amount = amount;
        }
        if (receiver != null) {
            this.receiver = receiver;
        }
        if (closeRemainderTo != null) {
            this.closeRemainderTo = closeRemainderTo;
        }
    }

    @Deprecated
    public static Transaction createPaymentTransaction(Address sender, BigInteger fee, BigInteger firstValid, BigInteger lastValid, byte[] note, String genesisID, Digest genesisHash, BigInteger amount, Address receiver, Address closeRemainderTo) {
        Objects.requireNonNull(sender, "sender is required.");
        Objects.requireNonNull(firstValid, "firstValid is required.");
        Objects.requireNonNull(lastValid, "lastValid is required.");
        Objects.requireNonNull(genesisHash, "genesisHash is required.");
        if (sender == null && closeRemainderTo == null) {
            throw new IllegalArgumentException("Must set at least one of 'receiver' or 'closeRemainderTo'");
        }
        return new Transaction(Type.Payment, sender, fee, firstValid, lastValid, note, genesisID, genesisHash, null, null, null, amount, receiver, closeRemainderTo, null, null, null, null, null, null, false, null, null, null, null, null, null, null, null, null, false, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Deprecated
    public Transaction(Address sender, BigInteger fee, BigInteger firstValid, BigInteger lastValid, byte[] note, String genesisID, Digest genesisHash, ParticipationPublicKey votePK, VRFPublicKey vrfPK, BigInteger voteFirst, BigInteger voteLast, BigInteger voteKeyDilution) {
        this.type = Type.KeyRegistration;
        if (sender != null) {
            this.sender = sender;
        }
        this.setFee(fee);
        if (firstValid != null) {
            this.firstValid = firstValid;
        }
        if (lastValid != null) {
            this.lastValid = lastValid;
        }
        this.setNote(note);
        if (genesisID != null) {
            this.genesisID = genesisID;
        }
        if (genesisHash != null) {
            this.genesisHash = genesisHash;
        }
        if (votePK != null) {
            this.votePK = votePK;
        }
        if (vrfPK != null) {
            this.selectionPK = vrfPK;
        }
        if (voteFirst != null) {
            this.voteFirst = voteFirst;
        }
        if (voteLast != null) {
            this.voteLast = voteLast;
        }
        if (voteKeyDilution != null) {
            this.voteKeyDilution = voteKeyDilution;
        }
    }

    @Deprecated
    public static Transaction createKeyRegistrationTransaction(Address sender, BigInteger fee, BigInteger firstValid, BigInteger lastValid, byte[] note, String genesisID, Digest genesisHash, ParticipationPublicKey votePK, VRFPublicKey vrfPK, BigInteger voteFirst, BigInteger voteLast, BigInteger voteKeyDilution) {
        Objects.requireNonNull(sender, "sender is required");
        Objects.requireNonNull(firstValid, "firstValid is required");
        Objects.requireNonNull(lastValid, "lastValid is required");
        Objects.requireNonNull(genesisHash, "genesisHash is required");
        return new Transaction(Type.KeyRegistration, sender, fee, firstValid, lastValid, note, genesisID, genesisHash, null, null, null, null, null, null, votePK, vrfPK, voteFirst, voteLast, voteKeyDilution, null, null, null, null, null, null, null, null, null, false, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Deprecated
    private Transaction(Address sender, BigInteger fee, BigInteger firstValid, BigInteger lastValid, byte[] note, String genesisID, Digest genesisHash, BigInteger assetTotal, Integer assetDecimals, boolean defaultFrozen, String assetUnitName, String assetName, String url, byte[] metadataHash, Address manager, Address reserve, Address freeze, Address clawback) {
        this.type = Type.AssetConfig;
        if (sender != null) {
            this.sender = sender;
        }
        this.setFee(fee);
        if (firstValid != null) {
            this.firstValid = firstValid;
        }
        if (lastValid != null) {
            this.lastValid = lastValid;
        }
        this.setNote(note);
        if (genesisID != null) {
            this.genesisID = genesisID;
        }
        if (genesisHash != null) {
            this.genesisHash = genesisHash;
        }
        this.assetParams = new AssetParams(assetTotal, assetDecimals, defaultFrozen, assetUnitName, assetName, url, metadataHash, manager, reserve, freeze, clawback);
    }

    @Deprecated
    public static Transaction createAssetCreateTransaction(Address sender, BigInteger fee, BigInteger firstValid, BigInteger lastValid, byte[] note, String genesisID, Digest genesisHash, BigInteger assetTotal, Integer assetDecimals, boolean defaultFrozen, String assetUnitName, String assetName, String url, byte[] metadataHash, Address manager, Address reserve, Address freeze, Address clawback) {
        Objects.requireNonNull(sender, "sender is required.");
        Objects.requireNonNull(firstValid, "firstValid is required.");
        Objects.requireNonNull(lastValid, "lastValid is required.");
        Objects.requireNonNull(genesisHash, "genesisHash is required.");
        Objects.requireNonNull(assetTotal, "assetTotal is required.");
        Objects.requireNonNull(assetDecimals, "assetDecimals is required.");
        AssetParams params = new AssetParams(assetTotal, assetDecimals, defaultFrozen, assetUnitName, assetName, url, metadataHash, manager, reserve, freeze, clawback);
        return new Transaction(Type.AssetConfig, sender, fee, firstValid, lastValid, note, genesisID, genesisHash, null, null, null, null, null, null, null, null, null, null, null, null, false, params, null, null, null, null, null, null, null, null, false, null, null, null, null, null, null, null, null, null, null, null);
    }

    private Transaction(Address sender, BigInteger fee, BigInteger firstValid, BigInteger lastValid, byte[] note, String genesisID, Digest genesisHash, BigInteger index, Address manager, Address reserve, Address freeze, Address clawback) {
        this.type = Type.AssetConfig;
        if (sender != null) {
            this.sender = sender;
        }
        this.setFee(fee);
        if (firstValid != null) {
            this.firstValid = firstValid;
        }
        if (lastValid != null) {
            this.lastValid = lastValid;
        }
        this.setNote(note);
        if (genesisID != null) {
            this.genesisID = genesisID;
        }
        if (genesisHash != null) {
            this.genesisHash = genesisHash;
        }
        this.assetParams = new AssetParams(BigInteger.valueOf(0L), (Integer)0, false, "", "", "", null, manager, reserve, freeze, clawback);
        this.assetIndex = index;
    }

    @Deprecated
    public static Transaction createAssetConfigureTransaction(Address sender, BigInteger fee, BigInteger firstValid, BigInteger lastValid, byte[] note, String genesisID, Digest genesisHash, BigInteger index, Address manager, Address reserve, Address freeze, Address clawback, boolean strictEmptyAddressChecking) {
        Address defaultAddr = new Address();
        if (strictEmptyAddressChecking && (manager == null || manager.equals(defaultAddr) || reserve == null || reserve.equals(defaultAddr) || freeze == null || freeze.equals(defaultAddr) || clawback == null || clawback.equals(defaultAddr))) {
            throw new RuntimeException("strict empty address checking requested but empty or default address supplied to one or more manager addresses");
        }
        return new Transaction(sender, fee, firstValid, lastValid, note, genesisID, genesisHash, index, manager, reserve, freeze, clawback);
    }

    private static List<Address> convertToAddressList(List<byte[]> addressBytes) {
        if (addressBytes == null) {
            return null;
        }
        ArrayList<Address> result = new ArrayList<Address>();
        for (byte[] addr : addressBytes) {
            result.add(new Address(addr));
        }
        return result;
    }

    @JsonCreator
    private Transaction(@JsonProperty(value="type") Type type, @JsonProperty(value="snd") byte[] sender, @JsonProperty(value="fee") BigInteger fee, @JsonProperty(value="fv") BigInteger firstValid, @JsonProperty(value="lv") BigInteger lastValid, @JsonProperty(value="note") byte[] note, @JsonProperty(value="gen") String genesisID, @JsonProperty(value="gh") byte[] genesisHash, @JsonProperty(value="lx") byte[] lease, @JsonProperty(value="rekey") byte[] rekeyTo, @JsonProperty(value="grp") byte[] group, @JsonProperty(value="amt") BigInteger amount, @JsonProperty(value="rcv") byte[] receiver, @JsonProperty(value="close") byte[] closeRemainderTo, @JsonProperty(value="votekey") byte[] votePK, @JsonProperty(value="selkey") byte[] vrfPK, @JsonProperty(value="sprfkey") byte[] stateProofKey, @JsonProperty(value="votefst") BigInteger voteFirst, @JsonProperty(value="votelst") BigInteger voteLast, @JsonProperty(value="votekd") BigInteger voteKeyDilution, @JsonProperty(value="nonpart") boolean nonpart, @JsonProperty(value="apar") AssetParams assetParams, @JsonProperty(value="caid") BigInteger assetIndex, @JsonProperty(value="xaid") BigInteger xferAsset, @JsonProperty(value="aamt") BigInteger assetAmount, @JsonProperty(value="asnd") byte[] assetSender, @JsonProperty(value="arcv") byte[] assetReceiver, @JsonProperty(value="aclose") byte[] assetCloseTo, @JsonProperty(value="fadd") byte[] freezeTarget, @JsonProperty(value="faid") BigInteger assetFreezeID, @JsonProperty(value="afrz") boolean freezeState, @JsonProperty(value="apaa") List<byte[]> applicationArgs, @JsonProperty(value="apan") OnCompletion onCompletion, @JsonProperty(value="apap") byte[] approvalProgram, @JsonProperty(value="apat") List<byte[]> accounts, @JsonProperty(value="apfa") List<Long> foreignApps, @JsonProperty(value="apas") List<Long> foreignAssets, @JsonProperty(value="apgs") StateSchema globalStateSchema, @JsonProperty(value="apid") Long applicationId, @JsonProperty(value="apls") StateSchema localStateSchema, @JsonProperty(value="apsu") byte[] clearStateProgram, @JsonProperty(value="apep") Long extraPages) throws IOException {
        this(type, new Address(sender), fee, firstValid, lastValid, note, genesisID, new Digest(genesisHash), lease, new Address(rekeyTo), new Digest(group), amount, new Address(receiver), new Address(closeRemainderTo), new ParticipationPublicKey(votePK), new VRFPublicKey(vrfPK), new MerkleVerifier(stateProofKey), voteFirst, voteLast, voteKeyDilution, nonpart, assetParams, assetIndex, xferAsset, assetAmount, new Address(assetSender), new Address(assetReceiver), new Address(assetCloseTo), new Address(freezeTarget), assetFreezeID, freezeState, applicationArgs, onCompletion, approvalProgram == null ? null : new TEALProgram(approvalProgram), Transaction.convertToAddressList(accounts), foreignApps, foreignAssets, globalStateSchema, applicationId, localStateSchema, clearStateProgram == null ? null : new TEALProgram(clearStateProgram), extraPages);
    }

    @Deprecated
    public Transaction(Type type, Address sender, BigInteger fee, BigInteger firstValid, BigInteger lastValid, byte[] note, String genesisID, Digest genesisHash, byte[] lease, Address rekeyTo, Digest group, BigInteger amount, Address receiver, Address closeRemainderTo, ParticipationPublicKey votePK, VRFPublicKey vrfPK, BigInteger voteFirst, BigInteger voteLast, BigInteger voteKeyDilution, AssetParams assetParams, BigInteger assetIndex, BigInteger xferAsset, BigInteger assetAmount, Address assetSender, Address assetReceiver, Address assetCloseTo, Address freezeTarget, BigInteger assetFreezeID, boolean freezeState, List<byte[]> applicationArgs, OnCompletion onCompletion, TEALProgram approvalProgram, List<Address> accounts, List<Long> foreignApps, List<Long> foreignAssets, StateSchema globalStateSchema, Long applicationId, StateSchema localStateSchema, TEALProgram clearStateProgram, Long extraPages) {
        this(type, sender, fee, firstValid, lastValid, note, genesisID, genesisHash, lease, rekeyTo, group, amount, receiver, closeRemainderTo, votePK, vrfPK, new MerkleVerifier(), voteFirst, voteLast, voteKeyDilution, false, assetParams, assetIndex, xferAsset, assetAmount, assetSender, assetReceiver, assetCloseTo, freezeTarget, assetFreezeID, freezeState, applicationArgs, onCompletion, approvalProgram == null ? null : approvalProgram, accounts, foreignApps, foreignAssets, globalStateSchema, applicationId, localStateSchema, clearStateProgram == null ? null : clearStateProgram, extraPages);
    }

    public Transaction(Type type, Address sender, BigInteger fee, BigInteger firstValid, BigInteger lastValid, byte[] note, String genesisID, Digest genesisHash, byte[] lease, Address rekeyTo, Digest group, BigInteger amount, Address receiver, Address closeRemainderTo, ParticipationPublicKey votePK, VRFPublicKey vrfPK, MerkleVerifier stateProofKey, BigInteger voteFirst, BigInteger voteLast, BigInteger voteKeyDilution, boolean nonpart, AssetParams assetParams, BigInteger assetIndex, BigInteger xferAsset, BigInteger assetAmount, Address assetSender, Address assetReceiver, Address assetCloseTo, Address freezeTarget, BigInteger assetFreezeID, boolean freezeState, List<byte[]> applicationArgs, OnCompletion onCompletion, TEALProgram approvalProgram, List<Address> accounts, List<Long> foreignApps, List<Long> foreignAssets, StateSchema globalStateSchema, Long applicationId, StateSchema localStateSchema, TEALProgram clearStateProgram, Long extraPages) {
        if (type != null) {
            this.type = type;
        }
        if (sender != null) {
            this.sender = sender;
        }
        this.setFee(fee);
        if (firstValid != null) {
            this.firstValid = firstValid;
        }
        if (lastValid != null) {
            this.lastValid = lastValid;
        }
        this.setNote(note);
        if (genesisID != null) {
            this.genesisID = genesisID;
        }
        if (genesisHash != null) {
            this.genesisHash = genesisHash;
        }
        this.setLease(lease);
        if (rekeyTo != null) {
            this.rekeyTo = rekeyTo;
        }
        if (group != null) {
            this.group = group;
        }
        if (amount != null) {
            this.amount = amount;
        }
        if (receiver != null) {
            this.receiver = receiver;
        }
        if (closeRemainderTo != null) {
            this.closeRemainderTo = closeRemainderTo;
        }
        if (votePK != null) {
            this.votePK = votePK;
        }
        if (vrfPK != null) {
            this.selectionPK = vrfPK;
        }
        if (stateProofKey != null) {
            this.stateProofKey = stateProofKey;
        }
        if (voteFirst != null) {
            this.voteFirst = voteFirst;
        }
        if (voteLast != null) {
            this.voteLast = voteLast;
        }
        if (voteKeyDilution != null) {
            this.voteKeyDilution = voteKeyDilution;
        }
        this.nonpart = nonpart;
        if (assetParams != null) {
            this.assetParams = assetParams;
        }
        if (assetIndex != null) {
            this.assetIndex = assetIndex;
        }
        if (xferAsset != null) {
            this.xferAsset = xferAsset;
        }
        if (assetAmount != null) {
            this.assetAmount = assetAmount;
        }
        if (assetSender != null) {
            this.assetSender = assetSender;
        }
        if (assetReceiver != null) {
            this.assetReceiver = assetReceiver;
        }
        if (assetCloseTo != null) {
            this.assetCloseTo = assetCloseTo;
        }
        if (freezeTarget != null) {
            this.freezeTarget = freezeTarget;
        }
        if (assetFreezeID != null) {
            this.assetFreezeID = assetFreezeID;
        }
        this.freezeState = freezeState;
        if (applicationArgs != null) {
            this.applicationArgs = applicationArgs;
        }
        if (onCompletion != null) {
            this.onCompletion = onCompletion;
        }
        if (approvalProgram != null) {
            this.approvalProgram = approvalProgram;
        }
        if (accounts != null) {
            this.accounts = accounts;
        }
        if (foreignApps != null) {
            this.foreignApps = foreignApps;
        }
        if (foreignAssets != null) {
            this.foreignAssets = foreignAssets;
        }
        if (globalStateSchema != null) {
            this.globalStateSchema = globalStateSchema;
        }
        if (applicationId != null) {
            this.applicationId = applicationId;
        }
        if (localStateSchema != null) {
            this.localStateSchema = globalStateSchema;
        }
        if (clearStateProgram != null) {
            this.clearStateProgram = clearStateProgram;
        }
        if (extraPages != null) {
            this.extraPages = extraPages;
        }
    }

    public Transaction() {
    }

    private Transaction(Type type, BigInteger flatFee, BigInteger firstRound, BigInteger lastRound, byte[] note, Digest genesisHash) {
        this.type = type;
        this.setFee(flatFee);
        if (firstRound != null) {
            this.firstValid = firstRound;
        }
        if (lastRound != null) {
            this.lastValid = lastRound;
        }
        this.setNote(note);
        if (genesisHash != null) {
            this.genesisHash = genesisHash;
        }
    }

    @Deprecated
    public static Transaction createAssetAcceptTransaction(Address acceptingAccount, BigInteger flatFee, BigInteger firstRound, BigInteger lastRound, byte[] note, String genesisID, Digest genesisHash, BigInteger assetIndex) {
        Transaction tx = Transaction.createAssetTransferTransaction(acceptingAccount, acceptingAccount, new Address(), BigInteger.valueOf(0L), flatFee, firstRound, lastRound, note, genesisID, genesisHash, assetIndex);
        return tx;
    }

    @Deprecated
    public static Transaction createAssetDestroyTransaction(Address senderAccount, BigInteger flatFee, BigInteger firstValid, BigInteger lastValid, byte[] note, Digest genesisHash, BigInteger assetIndex) {
        Transaction tx = new Transaction(Type.AssetConfig, flatFee, firstValid, lastValid, note, genesisHash);
        if (assetIndex != null) {
            tx.assetIndex = assetIndex;
        }
        if (senderAccount != null) {
            tx.sender = senderAccount;
        }
        return tx;
    }

    @Deprecated
    public static Transaction createAssetFreezeTransaction(Address senderAccount, Address accountToFreeze, boolean freezeState, BigInteger flatFee, BigInteger firstValid, BigInteger lastValid, byte[] note, Digest genesisHash, BigInteger assetIndex) {
        Transaction tx = new Transaction(Type.AssetFreeze, flatFee, firstValid, lastValid, note, genesisHash);
        if (senderAccount != null) {
            tx.sender = senderAccount;
        }
        if (accountToFreeze != null) {
            tx.freezeTarget = accountToFreeze;
        }
        if (assetIndex != null) {
            tx.assetFreezeID = assetIndex;
        }
        tx.freezeState = freezeState;
        return tx;
    }

    @Deprecated
    public static Transaction createAssetRevokeTransaction(Address transactionSender, Address assetRevokedFrom, Address assetReceiver, BigInteger assetAmount, BigInteger flatFee, BigInteger firstRound, BigInteger lastRound, byte[] note, String genesisID, Digest genesisHash, BigInteger assetIndex) {
        Transaction tx = new Transaction(Type.AssetTransfer, flatFee, firstRound, lastRound, note, genesisHash);
        tx.assetReceiver = assetReceiver;
        tx.assetSender = assetRevokedFrom;
        tx.assetAmount = assetAmount;
        tx.sender = transactionSender;
        if (assetIndex != null) {
            tx.xferAsset = assetIndex;
        }
        return tx;
    }

    @Deprecated
    public static Transaction createAssetTransferTransaction(Address assetSender, Address assetReceiver, Address assetCloseTo, BigInteger assetAmount, BigInteger flatFee, BigInteger firstRound, BigInteger lastRound, byte[] note, String genesisID, Digest genesisHash, BigInteger assetIndex) {
        Transaction tx = new Transaction(Type.AssetTransfer, flatFee, firstRound, lastRound, note, genesisHash);
        if (assetReceiver != null) {
            tx.assetReceiver = assetReceiver;
        }
        if (assetCloseTo != null) {
            tx.assetCloseTo = assetCloseTo;
        }
        if (assetAmount != null) {
            tx.assetAmount = assetAmount;
        }
        if (assetSender != null) {
            tx.sender = assetSender;
        }
        if (assetIndex != null) {
            tx.xferAsset = assetIndex;
        }
        return tx;
    }

    private void setNote(byte[] note) {
        if (note != null && note.length != 0) {
            this.note = note;
        }
    }

    @Deprecated
    public void setFee(BigInteger fee) {
        this.fee = fee != null ? fee : Account.MIN_TX_FEE_UALGOS;
    }

    @Deprecated
    @JsonIgnore
    public void setLease(byte[] lease) {
        if (lease != null && lease.length != 0) {
            this.setLease(new Lease(lease));
        }
    }

    public void setLease(Lease lease) {
        if (lease != null) {
            this.lease = lease.getBytes();
        }
    }

    public byte[] bytes() throws IOException {
        try {
            return Encoder.encodeToMsgPack(this);
        }
        catch (IOException e) {
            throw new RuntimeException("serialization failed", e);
        }
    }

    public byte[] bytesToSign() throws IOException {
        try {
            byte[] encodedTx = Encoder.encodeToMsgPack(this);
            byte[] prefixEncodedTx = new byte[encodedTx.length + TX_SIGN_PREFIX.length];
            System.arraycopy(TX_SIGN_PREFIX, 0, prefixEncodedTx, 0, TX_SIGN_PREFIX.length);
            System.arraycopy(encodedTx, 0, prefixEncodedTx, TX_SIGN_PREFIX.length, encodedTx.length);
            return prefixEncodedTx;
        }
        catch (IOException e) {
            throw new RuntimeException("serialization failed: " + e.getMessage(), e);
        }
    }

    public Digest rawTxID() throws IOException {
        try {
            return new Digest(Digester.digest(this.bytesToSign()));
        }
        catch (IOException e) {
            throw new RuntimeException("tx computation failed", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("tx computation failed", e);
        }
    }

    public String txID() throws IOException, NoSuchAlgorithmException {
        return Encoder.encodeToBase32StripPad(this.rawTxID().getBytes());
    }

    public void assignGroupID(Digest gid) {
        this.group = gid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction that = (Transaction)o;
        return this.type == that.type && this.sender.equals(that.sender) && this.fee.equals(that.fee) && this.firstValid.equals(that.firstValid) && this.lastValid.equals(that.lastValid) && Arrays.equals(this.note, that.note) && this.genesisID.equals(that.genesisID) && this.genesisHash.equals(that.genesisHash) && Arrays.equals(this.lease, that.lease) && this.group.equals(that.group) && this.amount.equals(that.amount) && this.receiver.equals(that.receiver) && this.closeRemainderTo.equals(that.closeRemainderTo) && this.votePK.equals(that.votePK) && this.selectionPK.equals(that.selectionPK) && this.stateProofKey.equals(that.stateProofKey) && this.voteFirst.equals(that.voteFirst) && this.voteLast.equals(that.voteLast) && this.voteKeyDilution.equals(that.voteKeyDilution) && this.nonpart == that.nonpart && this.assetParams.equals(that.assetParams) && this.assetIndex.equals(that.assetIndex) && this.xferAsset.equals(that.xferAsset) && this.assetAmount.equals(that.assetAmount) && this.assetSender.equals(that.assetSender) && this.assetReceiver.equals(that.assetReceiver) && this.assetCloseTo.equals(that.assetCloseTo) && this.freezeTarget.equals(that.freezeTarget) && this.assetFreezeID.equals(that.assetFreezeID) && this.freezeState == that.freezeState && this.rekeyTo.equals(that.rekeyTo) && Arrays.equals(this.lease, ((Transaction)o).lease) && this.extraPages.equals(that.extraPages);
    }

    public static PaymentTransactionBuilder<?> PaymentTransactionBuilder() {
        return PaymentTransactionBuilder.Builder();
    }

    public static KeyRegistrationTransactionBuilder<?> KeyRegistrationTransactionBuilder() {
        return KeyRegistrationTransactionBuilder.Builder();
    }

    public static AssetCreateTransactionBuilder<?> AssetCreateTransactionBuilder() {
        return AssetCreateTransactionBuilder.Builder();
    }

    public static AssetConfigureTransactionBuilder<?> AssetConfigureTransactionBuilder() {
        return AssetConfigureTransactionBuilder.Builder();
    }

    public static AssetDestroyTransactionBuilder<?> AssetDestroyTransactionBuilder() {
        return AssetDestroyTransactionBuilder.Builder();
    }

    public static AssetAcceptTransactionBuilder<?> AssetAcceptTransactionBuilder() {
        return AssetAcceptTransactionBuilder.Builder();
    }

    public static AssetTransferTransactionBuilder<?> AssetTransferTransactionBuilder() {
        return AssetTransferTransactionBuilder.Builder();
    }

    public static AssetClawbackTransactionBuilder<?> AssetClawbackTransactionBuilder() {
        return AssetClawbackTransactionBuilder.Builder();
    }

    public static AssetFreezeTransactionBuilder<?> AssetFreezeTransactionBuilder() {
        return AssetFreezeTransactionBuilder.Builder();
    }

    public static ApplicationCreateTransactionBuilder<?> ApplicationCreateTransactionBuilder() {
        return ApplicationCreateTransactionBuilder.Builder();
    }

    public static ApplicationUpdateTransactionBuilder<?> ApplicationUpdateTransactionBuilder() {
        return ApplicationUpdateTransactionBuilder.Builder();
    }

    public static ApplicationDeleteTransactionBuilder<?> ApplicationDeleteTransactionBuilder() {
        return ApplicationDeleteTransactionBuilder.Builder();
    }

    public static ApplicationOptInTransactionBuilder<?> ApplicationOptInTransactionBuilder() {
        return ApplicationOptInTransactionBuilder.Builder();
    }

    public static ApplicationCloseTransactionBuilder<?> ApplicationCloseTransactionBuilder() {
        return ApplicationCloseTransactionBuilder.Builder();
    }

    public static ApplicationCallTransactionBuilder<?> ApplicationCallTransactionBuilder() {
        return ApplicationCallTransactionBuilder.Builder();
    }

    public static ApplicationClearTransactionBuilder<?> ApplicationClearTransactionBuilder() {
        return ApplicationClearTransactionBuilder.Builder();
    }

    public static enum Type {
        Default(""),
        Payment("pay"),
        KeyRegistration("keyreg"),
        AssetConfig("acfg"),
        AssetTransfer("axfer"),
        AssetFreeze("afrz"),
        ApplicationCall("appl"),
        StateProof("stpf");

        private static Map<String, Type> namesMap;
        private final String value;

        private Type(String value) {
            this.value = value;
        }

        @JsonCreator
        public static Type forValue(String value) {
            for (Type t : Type.values()) {
                if (!t.value.equalsIgnoreCase(value)) continue;
                return t;
            }
            return null;
        }

        @JsonValue
        public String toValue() {
            return this.value;
        }

        static {
            namesMap = new HashMap<String, Type>(6);
        }
    }

    public static enum OnCompletion {
        NoOpOC(0, "noop"),
        OptInOC(1, "optin"),
        CloseOutOC(2, "closeout"),
        ClearStateOC(3, "clearstate"),
        UpdateApplicationOC(4, "update"),
        DeleteApplicationOC(5, "delete");

        private final int serializedValue;
        private final String serializedName;

        private OnCompletion(int serializeValue, String serializedName) {
            this.serializedValue = serializeValue;
            this.serializedName = serializedName;
        }

        public static OnCompletion String(String name) {
            for (OnCompletion oc : OnCompletion.values()) {
                if (!oc.serializedName.equalsIgnoreCase(name)) continue;
                return oc;
            }
            return null;
        }

        @JsonCreator
        public static OnCompletion forValue(int value) {
            for (OnCompletion oc : OnCompletion.values()) {
                if (oc.serializedValue != value) continue;
                return oc;
            }
            return null;
        }

        @JsonValue
        public int toValue() {
            return this.serializedValue;
        }

        public String toString() {
            return this.serializedName;
        }
    }
}

