/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.transaction;

import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.crypto.LogicsigSignature;
import com.algorand.algosdk.crypto.MultisigSignature;
import com.algorand.algosdk.crypto.Signature;
import com.algorand.algosdk.transaction.Transaction;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.IOException;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

@JsonPropertyOrder(alphabetic=true)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class SignedTransaction
implements Serializable {
    @JsonProperty(value="txn")
    public Transaction tx = new Transaction();
    @JsonProperty(value="sig")
    public Signature sig = new Signature();
    @JsonProperty(value="msig")
    public MultisigSignature mSig = new MultisigSignature();
    @JsonProperty(value="lsig")
    public LogicsigSignature lSig = new LogicsigSignature();
    public Address authAddr = new Address();
    @JsonIgnore
    public String transactionID = "";

    @JsonProperty(value="sgnr")
    public void authAddr(byte[] sigAddr) throws NoSuchAlgorithmException {
        this.authAddr = new Address(sigAddr);
    }

    public SignedTransaction(Transaction tx, Signature sig, MultisigSignature mSig, LogicsigSignature lSig, String transactionID) {
        this.tx = Objects.requireNonNull(tx, "tx must not be null");
        this.mSig = Objects.requireNonNull(mSig, "mSig must not be null");
        this.sig = Objects.requireNonNull(sig, "sig must not be null");
        this.lSig = Objects.requireNonNull(lSig, "lSig must not be null");
        this.transactionID = Objects.requireNonNull(transactionID, "txID must not be null");
    }

    public SignedTransaction(Transaction tx, Signature sig) throws IOException, NoSuchAlgorithmException {
        this(tx, sig, new MultisigSignature(), new LogicsigSignature(), tx.txID());
    }

    public SignedTransaction(Transaction tx, Signature sig, String txId) {
        this(tx, sig, new MultisigSignature(), new LogicsigSignature(), txId);
    }

    public SignedTransaction(Transaction tx, MultisigSignature mSig) throws IOException, NoSuchAlgorithmException {
        this(tx, new Signature(), mSig, new LogicsigSignature(), tx.txID());
    }

    public SignedTransaction(Transaction tx, MultisigSignature mSig, String txId) {
        this(tx, new Signature(), mSig, new LogicsigSignature(), txId);
    }

    public SignedTransaction(Transaction tx, LogicsigSignature lSig) throws IOException, NoSuchAlgorithmException {
        this(tx, new Signature(), new MultisigSignature(), lSig, tx.txID());
    }

    public SignedTransaction(Transaction tx, LogicsigSignature lSig, String txId) {
        this(tx, new Signature(), new MultisigSignature(), lSig, txId);
    }

    private SignedTransaction() {
    }

    public SignedTransaction authAddr(Address authAddr) {
        this.authAddr = authAddr;
        return this;
    }

    @JsonCreator
    public SignedTransaction(@JsonProperty(value="txn") Transaction tx, @JsonProperty(value="sig") byte[] sig, @JsonProperty(value="msig") MultisigSignature mSig, @JsonProperty(value="lsig") LogicsigSignature lSig, @JsonProperty(value="sgnr") byte[] authAddr) {
        if (tx != null) {
            this.tx = tx;
        }
        if (sig != null) {
            this.sig = new Signature(sig);
        }
        if (mSig != null) {
            this.mSig = mSig;
        }
        if (lSig != null) {
            this.lSig = lSig;
        }
        if (authAddr != null) {
            this.authAddr = new Address(authAddr);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof SignedTransaction) {
            SignedTransaction actual = (SignedTransaction)obj;
            if (!this.tx.equals(actual.tx)) {
                return false;
            }
            if (!this.sig.equals(actual.sig)) {
                return false;
            }
            if (!this.lSig.equals(actual.lSig)) {
                return false;
            }
            if (!this.authAddr.equals(actual.authAddr)) {
                return false;
            }
            return this.mSig.equals(actual.mSig);
        }
        return false;
    }
}

