/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.transaction;

import com.algorand.algosdk.abi.ABIType;
import com.algorand.algosdk.abi.Method;
import com.algorand.algosdk.abi.TypeAddress;
import com.algorand.algosdk.abi.TypeTuple;
import com.algorand.algosdk.abi.TypeUint;
import com.algorand.algosdk.algod.client.model.TransactionParams;
import com.algorand.algosdk.builder.transaction.ApplicationCallTransactionBuilder;
import com.algorand.algosdk.builder.transaction.MethodCallTransactionBuilder;
import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.crypto.Digest;
import com.algorand.algosdk.crypto.TEALProgram;
import com.algorand.algosdk.logic.StateSchema;
import com.algorand.algosdk.transaction.Transaction;
import com.algorand.algosdk.transaction.TransactionWithSigner;
import com.algorand.algosdk.transaction.TxnSigner;
import com.algorand.algosdk.v2.client.model.TransactionParametersResponse;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class MethodCallParams {
    private static final int MAX_ABI_ARG_TYPE_LEN = 15;
    private static final int FOREIGN_OBJ_ABI_UINT_SIZE = 8;
    public final Long appID;
    public final Transaction.OnCompletion onCompletion;
    public final Method method;
    public final List<Object> methodArgs;
    public final List<Address> foreignAccounts;
    public final List<Long> foreignAssets;
    public final List<Long> foreignApps;
    public final TEALProgram approvalProgram;
    public final TEALProgram clearProgram;
    public final StateSchema globalStateSchema;
    public final StateSchema localStateSchema;
    public final Long extraPages;
    public final TxnSigner signer;
    public final Address sender;
    public final BigInteger fee;
    public final BigInteger flatFee;
    public final BigInteger firstValid;
    public final BigInteger lastValid;
    public final byte[] note;
    public final byte[] lease;
    public final Address rekeyTo;
    public final String genesisID;
    public final Digest genesisHash;

    public MethodCallParams(Long appID, Method method, List<Object> methodArgs, Address sender, Transaction.OnCompletion onCompletion, byte[] note, byte[] lease, String genesisID, Digest genesisHash, BigInteger firstValid, BigInteger lastValid, BigInteger fee, BigInteger flatFee, Address rekeyTo, TxnSigner signer, List<Address> fAccounts, List<Long> fAssets, List<Long> fApps, TEALProgram approvalProgram, TEALProgram clearProgram, StateSchema globalStateSchema, StateSchema localStateSchema, Long extraPages) {
        if (appID == null || method == null || sender == null || onCompletion == null || signer == null || genesisID == null || genesisHash == null || firstValid == null || lastValid == null || fee == null && flatFee == null) {
            throw new IllegalArgumentException("Method call builder error: some required field not added");
        }
        if (fee != null && flatFee != null) {
            throw new IllegalArgumentException("Cannot set both fee and flatFee");
        }
        if (method.args.size() != methodArgs.size()) {
            throw new IllegalArgumentException("Method call error: incorrect method arg number provided");
        }
        if (appID == 0L) {
            if (approvalProgram == null || clearProgram == null || globalStateSchema == null || localStateSchema == null) {
                throw new IllegalArgumentException("One of the following required parameters for application creation is missing: approvalProgram, clearProgram, globalStateSchema, localStateSchema");
            }
        } else if (onCompletion == Transaction.OnCompletion.UpdateApplicationOC) {
            if (approvalProgram == null || clearProgram == null) {
                throw new IllegalArgumentException("One of the following required parameters for OnApplicationComplete.UpdateApplicationOC is missing: approvalProgram, clearProgram");
            }
            if (globalStateSchema != null || localStateSchema != null || extraPages != null) {
                throw new IllegalArgumentException("One of the following application creation parameters were set on a non-creation call: globalStateSchema, localStateSchema, extraPages");
            }
        } else if (approvalProgram != null || clearProgram != null || globalStateSchema != null || localStateSchema != null || extraPages != null) {
            throw new IllegalArgumentException("One of the following application creation parameters were set on a non-creation call: approvalProgram, clearProgram, globalStateSchema, localStateSchema, extraPages");
        }
        this.appID = appID;
        this.method = method;
        this.methodArgs = new ArrayList<Object>(methodArgs);
        this.sender = sender;
        this.onCompletion = onCompletion;
        this.note = note;
        this.lease = lease;
        this.genesisID = genesisID;
        this.genesisHash = genesisHash;
        this.firstValid = firstValid;
        this.lastValid = lastValid;
        this.fee = fee;
        this.flatFee = flatFee;
        this.rekeyTo = rekeyTo;
        this.signer = signer;
        this.foreignAccounts = new ArrayList<Address>(fAccounts);
        this.foreignAssets = new ArrayList<Long>(fAssets);
        this.foreignApps = new ArrayList<Long>(fApps);
        this.approvalProgram = approvalProgram;
        this.clearProgram = clearProgram;
        this.globalStateSchema = globalStateSchema;
        this.localStateSchema = localStateSchema;
        this.extraPages = extraPages;
    }

    public List<TransactionWithSigner> createTransactions() {
        int i;
        ArrayList<byte[]> encodedABIArgs = new ArrayList<byte[]>();
        encodedABIArgs.add(this.method.getSelector());
        List<Integer> methodArgs = new ArrayList<Object>();
        List<TypeUint> methodABIts = new ArrayList<ABIType>();
        ArrayList<TransactionWithSigner> transactionArgs = new ArrayList<TransactionWithSigner>();
        ArrayList<Address> foreignAccounts = new ArrayList<Address>(this.foreignAccounts);
        ArrayList<Long> foreignAssets = new ArrayList<Long>(this.foreignAssets);
        ArrayList<Long> foreignApps = new ArrayList<Long>(this.foreignApps);
        for (i = 0; i < this.method.args.size(); ++i) {
            Method.Arg argT = this.method.args.get(i);
            Object methodArg = this.methodArgs.get(i);
            if (argT.parsedType == null && methodArg instanceof TransactionWithSigner) {
                TransactionWithSigner twsConverted = (TransactionWithSigner)methodArg;
                if (!MethodCallParams.checkTransactionType(twsConverted, argT.type)) {
                    throw new IllegalArgumentException("expected transaction type " + argT.type + " not match with given " + twsConverted.txn.type.toValue());
                }
                transactionArgs.add((TransactionWithSigner)methodArg);
                continue;
            }
            if (Method.RefArgTypes.contains(argT.type)) {
                TypeUint abiUintT;
                int index;
                if (argT.type.equals("account")) {
                    TypeAddress abiAddressT = new TypeAddress();
                    Address accountAddress = (Address)abiAddressT.decode(abiAddressT.encode(methodArg));
                    index = MethodCallParams.populateForeignArrayIndex(accountAddress, foreignAccounts, this.sender);
                } else if (argT.type.equals("asset") && methodArg instanceof BigInteger) {
                    abiUintT = new TypeUint(64);
                    BigInteger assetID = (BigInteger)abiUintT.decode(abiUintT.encode(methodArg));
                    index = MethodCallParams.populateForeignArrayIndex(assetID.longValue(), foreignAssets, null);
                } else if (argT.type.equals("application") && methodArg instanceof BigInteger) {
                    abiUintT = new TypeUint(64);
                    BigInteger appID = (BigInteger)abiUintT.decode(abiUintT.encode(methodArg));
                    index = MethodCallParams.populateForeignArrayIndex(appID.longValue(), foreignApps, this.appID);
                } else {
                    throw new IllegalArgumentException("cannot add method call in AtomicTransactionComposer: ForeignArray arg type not matching");
                }
                methodArgs.add(index);
                methodABIts.add(new TypeUint(8));
                continue;
            }
            if (argT.parsedType != null) {
                methodArgs.add((Integer)methodArg);
                methodABIts.add((TypeUint)argT.parsedType);
                continue;
            }
            throw new IllegalArgumentException("error: the type of method argument is a transaction-type, but no transaction-with-signer provided");
        }
        if (methodArgs.size() > 15) {
            ArrayList<ABIType> wrappedABITypeList = new ArrayList<ABIType>();
            ArrayList wrappedValueList = new ArrayList();
            for (int i2 = 14; i2 < methodArgs.size(); ++i2) {
                wrappedABITypeList.add((ABIType)methodABIts.get(i2));
                wrappedValueList.add(methodArgs.get(i2));
            }
            TypeTuple tupleT = new TypeTuple(wrappedABITypeList);
            methodABIts = methodABIts.subList(0, 14);
            methodABIts.add((TypeUint)((Object)tupleT));
            methodArgs = methodArgs.subList(0, 14);
            methodArgs.add((Integer)((Object)wrappedValueList));
        }
        for (i = 0; i < methodArgs.size(); ++i) {
            encodedABIArgs.add(((ABIType)methodABIts.get(i)).encode(methodArgs.get(i)));
        }
        ApplicationCallTransactionBuilder<?> txBuilder = ApplicationCallTransactionBuilder.Builder();
        ((ApplicationCallTransactionBuilder)((ApplicationCallTransactionBuilder)((ApplicationCallTransactionBuilder)((ApplicationCallTransactionBuilder)((ApplicationCallTransactionBuilder)((ApplicationCallTransactionBuilder)((ApplicationCallTransactionBuilder)((ApplicationCallTransactionBuilder)((ApplicationCallTransactionBuilder)((ApplicationCallTransactionBuilder)((ApplicationCallTransactionBuilder)((ApplicationCallTransactionBuilder)((ApplicationCallTransactionBuilder)((ApplicationCallTransactionBuilder)txBuilder.firstValid(this.firstValid)).lastValid(this.lastValid)).genesisHash(this.genesisHash)).genesisID(this.genesisID)).fee(this.fee)).flatFee(this.flatFee)).note(this.note)).lease(this.lease)).rekey(this.rekeyTo)).sender(this.sender)).applicationId(this.appID)).args(encodedABIArgs)).accounts(foreignAccounts)).foreignApps(foreignApps)).foreignAssets(foreignAssets);
        Transaction tx = txBuilder.build();
        tx.onCompletion = this.onCompletion;
        tx.approvalProgram = this.approvalProgram;
        tx.clearStateProgram = this.clearProgram;
        if (this.globalStateSchema != null) {
            tx.globalStateSchema = this.globalStateSchema;
        }
        if (this.localStateSchema != null) {
            tx.localStateSchema = this.localStateSchema;
        }
        if (this.extraPages != null) {
            tx.extraPages = this.extraPages;
        }
        TransactionWithSigner methodCall = new TransactionWithSigner(tx, this.signer);
        transactionArgs.add(methodCall);
        return transactionArgs;
    }

    private static boolean checkTransactionType(TransactionWithSigner tws, String txnType) {
        if (txnType.equals("txn")) {
            return true;
        }
        return tws.txn.type.toValue().equals(txnType);
    }

    private static <T> int populateForeignArrayIndex(T objectToBeAdded, List<T> objectArray, T zerothObject) {
        if (objectToBeAdded.equals(zerothObject)) {
            return 0;
        }
        int startFrom = zerothObject == null ? 0 : 1;
        int searchInListIndex = objectArray.indexOf(objectToBeAdded);
        if (searchInListIndex != -1) {
            return startFrom + searchInListIndex;
        }
        objectArray.add(objectToBeAdded);
        return objectArray.size() - 1 + startFrom;
    }

    @Deprecated
    public static class Builder
    extends MethodCallTransactionBuilder<Builder> {
        public Builder setAppID(Long appID) {
            return (Builder)this.applicationId(appID);
        }

        public Builder setMethod(Method method) {
            return (Builder)this.method(method);
        }

        public Builder addMethodArgs(Object ma) {
            return (Builder)this.addMethodArgument(ma);
        }

        public Builder setSender(String sender) {
            return (Builder)this.sender(sender);
        }

        public Builder setSuggestedParams(TransactionParams sp) {
            return (Builder)this.suggestedParams(sp);
        }

        public Builder setSuggestedParams(TransactionParametersResponse sp) {
            return (Builder)this.suggestedParams(sp);
        }

        public Builder setOnComplete(Transaction.OnCompletion op) {
            return (Builder)this.onComplete(op);
        }

        public Builder setNote(byte[] note) {
            return (Builder)this.note(note);
        }

        public Builder setLease(byte[] lease) {
            return (Builder)this.lease(lease);
        }

        public Builder setRekeyTo(String rekeyTo) {
            return (Builder)this.rekey(rekeyTo);
        }

        public Builder setSigner(TxnSigner signer) {
            return (Builder)this.signer(signer);
        }

        public Builder setFirstValid(BigInteger fv) {
            return (Builder)this.firstValid(fv);
        }

        public Builder setLastValid(BigInteger lv) {
            return (Builder)this.lastValid(lv);
        }

        public Builder setFee(BigInteger fee) {
            return (Builder)this.fee(fee);
        }

        public Builder setFlatFee(BigInteger flatFee) {
            return (Builder)this.flatFee(flatFee);
        }

        public Builder setForeignAccounts(List<Address> fAccounts) {
            return (Builder)this.accounts((List)fAccounts);
        }

        public Builder setForeignAssets(List<Long> fAssets) {
            return (Builder)this.foreignAssets((List)fAssets);
        }

        public Builder setForeignApps(List<Long> fApps) {
            return (Builder)this.foreignApps((List)fApps);
        }

        public Builder setApprovalProgram(TEALProgram approvalProgram) {
            return (Builder)this.approvalProgram(approvalProgram);
        }

        public Builder setClearProgram(TEALProgram clearProgram) {
            return (Builder)this.clearStateProgram(clearProgram);
        }

        public Builder setGlobalInts(Long globalInts) {
            if (this.globalStateSchema == null) {
                return (Builder)this.globalStateSchema(new StateSchema(globalInts, 0L));
            }
            this.globalStateSchema.numUint = BigInteger.valueOf(globalInts);
            return this;
        }

        public Builder setGlobalBytes(Long globalBytes) {
            if (this.globalStateSchema == null) {
                return (Builder)this.globalStateSchema(new StateSchema(0L, globalBytes));
            }
            this.globalStateSchema.numByteSlice = BigInteger.valueOf(globalBytes);
            return this;
        }

        public Builder setLocalInts(Long localInts) {
            if (this.localStateSchema == null) {
                return (Builder)this.localStateSchema(new StateSchema(localInts, 0L));
            }
            this.localStateSchema.numUint = BigInteger.valueOf(localInts);
            return this;
        }

        public Builder setLocalBytes(Long localBytes) {
            if (this.localStateSchema == null) {
                return (Builder)this.localStateSchema(new StateSchema(0L, localBytes));
            }
            this.localStateSchema.numByteSlice = BigInteger.valueOf(localBytes);
            return this;
        }

        public Builder setExtraPages(Long extraPages) {
            return (Builder)this.extraPages(extraPages);
        }
    }
}

