/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.transaction;

import com.algorand.algosdk.util.Encoder;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Random;

public class Lease {
    public static final int LEASE_LENGTH = 32;
    private final byte[] data;

    public Lease() {
        this(Lease.makeRandomLease());
    }

    public Lease(String lease) {
        this(Encoder.decodeFromBase64(lease));
    }

    @JsonCreator
    public Lease(byte[] lease) {
        if (!Lease.valid(lease)) {
            throw new IllegalArgumentException("Leases should be 0 or 32 bytes long, received: " + lease.length + " bytes");
        }
        this.data = lease;
    }

    @JsonValue
    public byte[] getBytes() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    public String toString() {
        return Encoder.encodeToBase64(this.data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Arrays.equals(((Lease)o).data, this.data);
    }

    private static boolean valid(byte[] value) {
        return value.length == 32 || value.length == 0;
    }

    private static byte[] makeRandomLease() {
        byte[] result = new byte[32];
        new Random().nextBytes(result);
        return result;
    }
}

