/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.transaction;

import com.algorand.algosdk.abi.ABIType;
import com.algorand.algosdk.abi.Method;
import com.algorand.algosdk.crypto.Digest;
import com.algorand.algosdk.transaction.MethodCallParams;
import com.algorand.algosdk.transaction.SignedTransaction;
import com.algorand.algosdk.transaction.Transaction;
import com.algorand.algosdk.transaction.TransactionWithSigner;
import com.algorand.algosdk.transaction.TxGroup;
import com.algorand.algosdk.transaction.TxnSigner;
import com.algorand.algosdk.util.Encoder;
import com.algorand.algosdk.v2.client.Utils;
import com.algorand.algosdk.v2.client.common.AlgodClient;
import com.algorand.algosdk.v2.client.common.Response;
import com.algorand.algosdk.v2.client.model.PendingTransactionResponse;
import com.algorand.algosdk.v2.client.model.PostTransactionsResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class AtomicTransactionComposer {
    public static final int MAX_GROUP_SIZE = 16;
    private static final byte[] ABI_RET_HASH = new byte[]{21, 31, 124, 117};
    private Status status = Status.BUILDING;
    private final Map<Integer, Method> methodMap = new HashMap<Integer, Method>();
    private final List<TransactionWithSigner> transactionList = new ArrayList<TransactionWithSigner>();
    private List<SignedTransaction> signedTxns = new ArrayList<SignedTransaction>();

    public Status getStatus() {
        return this.status;
    }

    public int getCount() {
        return this.transactionList.size();
    }

    public AtomicTransactionComposer cloneComposer() throws IOException {
        AtomicTransactionComposer cloned = new AtomicTransactionComposer();
        cloned.methodMap.putAll(this.methodMap);
        ObjectMapper om = new ObjectMapper();
        for (TransactionWithSigner txWithSigner : this.transactionList) {
            byte[] txSerialized = om.writeValueAsBytes((Object)txWithSigner.txn);
            Transaction tx = (Transaction)om.readValue(txSerialized, Transaction.class);
            tx.group = new Digest();
            TransactionWithSigner newTxWithSigner = new TransactionWithSigner(tx, txWithSigner.signer);
            cloned.transactionList.add(newTxWithSigner);
        }
        return cloned;
    }

    public void addTransaction(TransactionWithSigner txnAndSigner) {
        if (!txnAndSigner.txn.group.equals(new Digest())) {
            throw new IllegalArgumentException("Atomic Transaction Composer group field must be zero");
        }
        if (!this.status.equals((Object)Status.BUILDING)) {
            throw new IllegalArgumentException("Atomic Transaction Composer only add transaction in BUILDING stage");
        }
        if (this.transactionList.size() == 16) {
            throw new IllegalArgumentException("Atomic Transaction Composer cannot exceed MAX_GROUP_SIZE == 16 transactions");
        }
        this.transactionList.add(txnAndSigner);
    }

    public void addMethodCall(MethodCallParams methodCall) {
        if (!this.status.equals((Object)Status.BUILDING)) {
            throw new IllegalArgumentException("Atomic Transaction Composer must be in BUILDING stage");
        }
        List<TransactionWithSigner> txns = methodCall.createTransactions();
        if (this.transactionList.size() + txns.size() > 16) {
            throw new IllegalArgumentException("Atomic Transaction Composer cannot exceed MAX_GROUP_SIZE = 16 transactions");
        }
        this.transactionList.addAll(txns);
        this.methodMap.put(this.transactionList.size() - 1, methodCall.method);
    }

    public List<TransactionWithSigner> buildGroup() throws IOException {
        if (this.status.compareTo(Status.BUILT) >= 0) {
            return this.transactionList;
        }
        if (this.transactionList.size() == 0) {
            throw new IllegalArgumentException("should not build transaction group with 0 transaction in composer");
        }
        if (this.transactionList.size() > 1) {
            ArrayList<Transaction> groupTxns = new ArrayList<Transaction>();
            for (TransactionWithSigner t : this.transactionList) {
                groupTxns.add(t.txn);
            }
            Digest groupID = TxGroup.computeGroupID(groupTxns.toArray(new Transaction[0]));
            for (TransactionWithSigner tws : this.transactionList) {
                tws.txn.group = groupID;
            }
        }
        this.status = Status.BUILT;
        return this.transactionList;
    }

    public List<SignedTransaction> gatherSignatures() throws Exception {
        int i;
        if (this.status.compareTo(Status.SIGNED) >= 0) {
            return this.signedTxns;
        }
        List<TransactionWithSigner> txnAndSignerList = this.buildGroup();
        HashMap txnSignerToIndices = new HashMap();
        ArrayList<SignedTransaction> tempSignedTxns = new ArrayList<SignedTransaction>();
        for (i = 0; i < txnAndSignerList.size(); ++i) {
            tempSignedTxns.add(null);
        }
        for (i = 0; i < txnAndSignerList.size(); ++i) {
            TransactionWithSigner tws = txnAndSignerList.get(i);
            if (!txnSignerToIndices.containsKey(tws.signer)) {
                txnSignerToIndices.put(tws.signer, new ArrayList());
            }
            ((List)txnSignerToIndices.get(tws.signer)).add(i);
        }
        Transaction[] txnGroup = new Transaction[txnAndSignerList.size()];
        for (int i2 = 0; i2 < txnAndSignerList.size(); ++i2) {
            txnGroup[i2] = txnAndSignerList.get((int)i2).txn;
        }
        for (TxnSigner txnSigner : txnSignerToIndices.keySet()) {
            List indices = (List)txnSignerToIndices.get(txnSigner);
            int[] indicesPrimitive = ArrayUtils.toPrimitive((Integer[])indices.toArray(new Integer[0]));
            SignedTransaction[] signed = txnSigner.signTxnGroup(txnGroup, indicesPrimitive);
            for (int i3 = 0; i3 < indicesPrimitive.length; ++i3) {
                tempSignedTxns.set(indicesPrimitive[i3], signed[i3]);
            }
        }
        if (tempSignedTxns.contains(null)) {
            throw new IllegalArgumentException("some signer did not sign the transaction");
        }
        this.signedTxns = tempSignedTxns;
        this.status = Status.SIGNED;
        return this.signedTxns;
    }

    protected List<String> getTxIDs() {
        ArrayList<String> txids = new ArrayList<String>();
        for (SignedTransaction stxn : this.signedTxns) {
            txids.add(stxn.transactionID);
        }
        return txids;
    }

    public List<String> submit(AlgodClient client) throws Exception {
        if (this.status.compareTo(Status.SUBMITTED) > 0) {
            throw new IllegalArgumentException("Atomic Transaction Composer cannot submit committed transaction");
        }
        this.gatherSignatures();
        ArrayList<byte[]> encodings = new ArrayList<byte[]>();
        int lengthEncoded = 0;
        for (SignedTransaction signedTransaction : this.signedTxns) {
            byte[] temp = Encoder.encodeToMsgPack(signedTransaction);
            encodings.add(temp);
            lengthEncoded += temp.length;
        }
        ByteBuffer bf = ByteBuffer.allocate(lengthEncoded);
        for (byte[] subEncode : encodings) {
            bf.put(subEncode);
        }
        byte[] byArray = bf.array();
        Response<PostTransactionsResponse> rPost = client.RawTransaction().rawtxn(byArray).execute();
        if (!rPost.isSuccessful()) {
            throw new Exception("transaction should be submitted successfully cause : " + rPost.message());
        }
        this.status = Status.SUBMITTED;
        return this.getTxIDs();
    }

    public ExecuteResult execute(AlgodClient client, int waitRounds) throws Exception {
        if (this.status == Status.COMMITTED) {
            throw new IllegalArgumentException("status shows this is already committed");
        }
        if (waitRounds < 0) {
            throw new IllegalArgumentException("wait round for execute should be non-negative");
        }
        this.submit(client);
        int indexToWait = 0;
        for (int i = 0; i < this.signedTxns.size(); ++i) {
            if (!this.methodMap.containsKey(i)) continue;
            indexToWait = i;
            break;
        }
        PendingTransactionResponse txInfo = Utils.waitForConfirmation(client, this.signedTxns.get((int)indexToWait).transactionID, waitRounds);
        ArrayList<ReturnValue> retList = new ArrayList<ReturnValue>();
        this.status = Status.COMMITTED;
        for (int i = 0; i < this.transactionList.size(); ++i) {
            if (!this.methodMap.containsKey(i)) continue;
            PendingTransactionResponse currentTxInfo = txInfo;
            if (i != indexToWait) {
                Response<PendingTransactionResponse> resp = client.PendingTransactionInformation(this.signedTxns.get((int)i).transactionID).execute();
                if (!resp.isSuccessful()) {
                    retList.add(new ReturnValue(this.signedTxns.get((int)i).transactionID, null, null, this.methodMap.get(i), new Exception(resp.message()), null));
                    continue;
                }
                currentTxInfo = resp.body();
            }
            if (this.methodMap.get((Object)Integer.valueOf((int)i)).returns.type.equals("void")) {
                retList.add(new ReturnValue(currentTxInfo.txn.transactionID, null, null, this.methodMap.get(i), null, currentTxInfo));
                continue;
            }
            if (currentTxInfo.logs.size() == 0) {
                throw new IllegalArgumentException("App call transaction did not log a return value");
            }
            byte[] retLine = currentTxInfo.logs.get(currentTxInfo.logs.size() - 1);
            if (!AtomicTransactionComposer.checkLogRet(retLine)) {
                throw new IllegalArgumentException("App call transaction did not log a return value");
            }
            byte[] abiEncoded = Arrays.copyOfRange(retLine, ABI_RET_HASH.length, retLine.length);
            Object decoded = null;
            Exception parseError = null;
            try {
                ABIType methodRetType = this.methodMap.get((Object)Integer.valueOf((int)i)).returns.parsedType;
                decoded = methodRetType.decode(abiEncoded);
            }
            catch (Exception e) {
                parseError = e;
            }
            retList.add(new ReturnValue(currentTxInfo.txn.transactionID, abiEncoded, decoded, this.methodMap.get(i), parseError, currentTxInfo));
        }
        return new ExecuteResult(txInfo.confirmedRound, this.getTxIDs(), retList);
    }

    private static boolean checkLogRet(byte[] logLine) {
        if (logLine.length < ABI_RET_HASH.length) {
            return false;
        }
        for (int i = 0; i < ABI_RET_HASH.length; ++i) {
            if (logLine[i] == ABI_RET_HASH[i]) continue;
            return false;
        }
        return true;
    }

    public static enum Status {
        BUILDING,
        BUILT,
        SIGNED,
        SUBMITTED,
        COMMITTED;

    }

    public static class ReturnValue {
        public String txID;
        public byte[] rawValue;
        public Object value;
        public Method method;
        public Exception parseError;
        public PendingTransactionResponse txInfo;

        public ReturnValue(String txID, byte[] rawValue, Object value, Method method, Exception parseError, PendingTransactionResponse txInfo) {
            this.txID = txID;
            this.rawValue = rawValue;
            this.value = value;
            this.method = method;
            this.parseError = parseError;
            this.txInfo = txInfo;
        }
    }

    public static class ExecuteResult {
        public Long confirmedRound;
        public List<String> txIDs;
        public List<ReturnValue> methodResults;

        public ExecuteResult(Long confirmedRound, List<String> txIDs, List<ReturnValue> methodResults) {
            this.confirmedRound = confirmedRound;
            this.txIDs = txIDs;
            this.methodResults = methodResults;
        }
    }
}

