/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.transaction;

import com.algorand.algosdk.crypto.Address;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;

@JsonPropertyOrder(alphabetic=true)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class AssetParams
implements Serializable {
    @JsonProperty(value="t")
    public BigInteger assetTotal = BigInteger.valueOf(0L);
    @JsonProperty(value="dc")
    public Integer assetDecimals = 0;
    @JsonProperty(value="df")
    public boolean assetDefaultFrozen = false;
    @JsonProperty(value="un")
    public String assetUnitName = "";
    @JsonProperty(value="an")
    public String assetName = "";
    @JsonProperty(value="au")
    public String url = "";
    @JsonProperty(value="am")
    public byte[] metadataHash;
    @JsonProperty(value="m")
    public Address assetManager = new Address();
    @JsonProperty(value="r")
    public Address assetReserve = new Address();
    @JsonProperty(value="f")
    public Address assetFreeze = new Address();
    @JsonProperty(value="c")
    public Address assetClawback = new Address();

    public AssetParams(BigInteger assetTotal, Integer assetDecimals, boolean defaultFrozen, String assetUnitName, String assetName, String url, byte[] metadataHash, Address manager, Address reserve, Address freeze, Address clawback) {
        if (assetTotal != null) {
            this.assetTotal = assetTotal;
        }
        if (assetDecimals != null) {
            this.assetDecimals = assetDecimals;
        }
        this.assetDefaultFrozen = defaultFrozen;
        if (manager != null) {
            this.assetManager = manager;
        }
        if (reserve != null) {
            this.assetReserve = reserve;
        }
        if (freeze != null) {
            this.assetFreeze = freeze;
        }
        if (clawback != null) {
            this.assetClawback = clawback;
        }
        if (assetDecimals != null) {
            if (assetDecimals < 0 || assetDecimals > 19) {
                throw new RuntimeException("assetDecimals cannot be less than 0 or greater than 19");
            }
            this.assetDecimals = assetDecimals;
        }
        if (assetUnitName != null) {
            if (assetUnitName.length() > 8) {
                throw new RuntimeException("assetUnitName cannot be greater than 8 characters");
            }
            this.assetUnitName = assetUnitName;
        }
        if (assetName != null) {
            if (assetName.length() > 32) {
                throw new RuntimeException("assetName cannot be greater than 32 characters");
            }
            this.assetName = assetName;
        }
        if (url != null) {
            if (url.length() > 96) {
                throw new RuntimeException("url length must be between 0 and 96 characters (inclusive).");
            }
            this.url = url;
        }
        if (metadataHash != null) {
            if (metadataHash.length != 32) {
                throw new RuntimeException("asset metadataHash must have 32 bytes");
            }
            this.metadataHash = metadataHash;
        }
    }

    public AssetParams() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetParams that = (AssetParams)o;
        return this.assetTotal.equals(that.assetTotal) && this.assetDecimals.equals(that.assetDecimals) && this.assetDefaultFrozen == that.assetDefaultFrozen && this.assetName.equals(that.assetName) && this.assetUnitName.equals(that.assetUnitName) && this.url.equals(that.url) && Arrays.equals(this.metadataHash, that.metadataHash) && this.assetManager.equals(that.assetManager) && this.assetReserve.equals(that.assetReserve) && this.assetFreeze.equals(that.assetFreeze) && this.assetClawback.equals(that.assetClawback);
    }

    @JsonCreator
    private AssetParams(@JsonProperty(value="t") BigInteger assetTotal, @JsonProperty(value="dc") Integer assetDecimals, @JsonProperty(value="df") boolean assetDefaultFrozen, @JsonProperty(value="un") String assetUnitName, @JsonProperty(value="an") String assetName, @JsonProperty(value="au") String url, @JsonProperty(value="am") byte[] metadataHash, @JsonProperty(value="m") byte[] assetManager, @JsonProperty(value="r") byte[] assetReserve, @JsonProperty(value="f") byte[] assetFreeze, @JsonProperty(value="c") byte[] assetClawback) {
        this(assetTotal, assetDecimals, assetDefaultFrozen, assetUnitName, assetName, url, metadataHash, new Address(assetManager), new Address(assetReserve), new Address(assetFreeze), new Address(assetClawback));
    }
}

