/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.templates;

import com.algorand.algosdk.builder.transaction.PaymentTransactionBuilder;
import com.algorand.algosdk.builder.transaction.TransactionParametersBuilder;
import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.crypto.Digest;
import com.algorand.algosdk.crypto.LogicsigSignature;
import com.algorand.algosdk.logic.Logic;
import com.algorand.algosdk.templates.ContractTemplate;
import com.algorand.algosdk.transaction.SignedTransaction;
import com.algorand.algosdk.transaction.Transaction;
import com.algorand.algosdk.transaction.TxGroup;
import com.algorand.algosdk.util.Encoder;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.List;

@Deprecated
public class Split {
    private static String referenceProgram = "ASAIAQUCAAYHCAkmAyDYHIR7TIW5eM/WAZcXdEDqv7BD+baMN6i2/A5JatGbNCDKsaoZHPQ3Zg8zZB/BZ1oDgt77LGo5np3rbto3/gloTyB40AS2H3I72YCbDk4hKpm7J7NnFy2Xrt39TJG0ORFg+zEQIhIxASMMEDIEJBJAABkxCSgSMQcyAxIQMQglEhAxAiEEDRAiQAAuMwAAMwEAEjEJMgMSEDMABykSEDMBByoSEDMACCEFCzMBCCEGCxIQMwAIIQcPEBA=";

    public static ContractTemplate MakeSplit(Address owner, Address receiver1, Address receiver2, int rat1, int rat2, int expiryRound, int minPay, int maxFee) throws NoSuchAlgorithmException {
        ImmutableList values = ImmutableList.of((Object)new ContractTemplate.IntParameterValue(4, maxFee), (Object)new ContractTemplate.IntParameterValue(7, expiryRound), (Object)new ContractTemplate.IntParameterValue(8, rat2), (Object)new ContractTemplate.IntParameterValue(9, rat1), (Object)new ContractTemplate.IntParameterValue(10, minPay), (Object)new ContractTemplate.AddressParameterValue(14, owner), (Object)new ContractTemplate.AddressParameterValue(47, receiver1), (Object)new ContractTemplate.AddressParameterValue(80, receiver2));
        return ContractTemplate.inject(Encoder.decodeFromBase64(referenceProgram), (List<ContractTemplate.ParameterValue>)values);
    }

    public static byte[] GetSplitTransactions(ContractTemplate contract, int amount, int firstValid, int lastValid, int feePerByte, Digest genesisHash) throws NoSuchAlgorithmException, IOException {
        BigInteger rcv2;
        int receiverTwoAmount;
        Logic.ProgramData data = ContractTemplate.readAndVerifyContract(contract.program, 8, 3);
        int maxFee = data.intBlock.get(1);
        int rat1 = data.intBlock.get(6);
        int rat2 = data.intBlock.get(5);
        int minTrade = data.intBlock.get(7);
        Double fraction = Double.valueOf(rat1) / Double.valueOf(rat1 + rat2);
        int receiverOneAmount = Long.valueOf(Math.round(fraction * (double)amount)).intValue();
        if (amount - receiverOneAmount - (receiverTwoAmount = Long.valueOf(Math.round((1.0 - fraction) * (double)amount)).intValue()) != 0) {
            throw new RuntimeException("Unable to exactly split " + amount + " using the contract ratio of " + rat1 + " / " + rat2);
        }
        if (receiverOneAmount < minTrade) {
            throw new RuntimeException("Receiver one must receive at least " + minTrade);
        }
        BigInteger rcv1 = BigInteger.valueOf(receiverOneAmount).multiply(BigInteger.valueOf(rat2));
        if (!rcv1.equals(rcv2 = BigInteger.valueOf(receiverTwoAmount).multiply(BigInteger.valueOf(rat1)))) {
            throw new RuntimeException("The token split must be exactly " + rat1 + " / " + rat2 + ", received " + receiverOneAmount + " / " + receiverTwoAmount);
        }
        Address receiver1 = new Address(data.byteBlock.get(1));
        Address receiver2 = new Address(data.byteBlock.get(2));
        Transaction tx1 = ((PaymentTransactionBuilder)((PaymentTransactionBuilder)((PaymentTransactionBuilder)((TransactionParametersBuilder)((PaymentTransactionBuilder)((TransactionParametersBuilder)((PaymentTransactionBuilder)Transaction.PaymentTransactionBuilder().sender(contract.address)).receiver(receiver1)).fee(feePerByte)).amount(receiverOneAmount)).firstValid(firstValid)).lastValid(lastValid)).genesisHash(genesisHash)).build();
        Transaction tx2 = ((PaymentTransactionBuilder)((PaymentTransactionBuilder)((PaymentTransactionBuilder)((TransactionParametersBuilder)((PaymentTransactionBuilder)((TransactionParametersBuilder)((PaymentTransactionBuilder)Transaction.PaymentTransactionBuilder().sender(contract.address)).receiver(receiver2)).fee(feePerByte)).amount(receiverTwoAmount)).firstValid(firstValid)).lastValid(lastValid)).genesisHash(genesisHash)).build();
        if (tx1.fee.longValue() > (long)maxFee || tx2.fee.longValue() > (long)maxFee) {
            long fee = Math.max(tx1.fee.longValue(), tx2.fee.longValue());
            throw new RuntimeException("Transaction fee is greater than maxFee: " + fee + " > " + maxFee);
        }
        LogicsigSignature lsig = new LogicsigSignature(contract.program);
        TxGroup.assignGroupID(tx1, tx2);
        SignedTransaction stx1 = new SignedTransaction(tx1, lsig, tx1.txID());
        SignedTransaction stx2 = new SignedTransaction(tx2, lsig, tx2.txID());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(Encoder.encodeToMsgPack(stx1));
        baos.write(Encoder.encodeToMsgPack(stx2));
        return baos.toByteArray();
    }
}

