/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.templates;

import com.algorand.algosdk.account.Account;
import com.algorand.algosdk.builder.transaction.PaymentTransactionBuilder;
import com.algorand.algosdk.builder.transaction.TransactionParametersBuilder;
import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.crypto.Digest;
import com.algorand.algosdk.crypto.LogicsigSignature;
import com.algorand.algosdk.logic.Logic;
import com.algorand.algosdk.templates.ContractTemplate;
import com.algorand.algosdk.transaction.Lease;
import com.algorand.algosdk.transaction.SignedTransaction;
import com.algorand.algosdk.transaction.Transaction;
import com.algorand.algosdk.util.Encoder;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;

@Deprecated
public class PeriodicPayment {
    private static String referenceProgram = "ASAHAQoLAAwNDiYCAQYg/ryguxRKWk6ntDikaBrIDmyhBby2B/xWUyXJVpX2ohMxECISMQEjDhAxAiQYJRIQMQQhBDECCBIQMQYoEhAxCTIDEjEHKRIQMQghBRIQMQkpEjEHMgMSEDECIQYNEDEIJRIQERA=";

    public static ContractTemplate MakePeriodicPayment(Address receiver, int amount, int withdrawingWindow, int period, int fee, int expiryRound) throws NoSuchAlgorithmException {
        return PeriodicPayment.MakePeriodicPayment(receiver, amount, withdrawingWindow, period, fee, expiryRound, null);
    }

    protected static ContractTemplate MakePeriodicPayment(Address receiver, int amount, int withdrawingWindow, int period, int fee, int expiryRound, Lease lease) throws NoSuchAlgorithmException {
        if (withdrawingWindow < 0 || withdrawingWindow > 1000) {
            throw new IllegalArgumentException("The withdrawingWindow must be a positive number less than 1000");
        }
        ImmutableList values = ImmutableList.of((Object)new ContractTemplate.IntParameterValue(4, fee), (Object)new ContractTemplate.IntParameterValue(5, period), (Object)new ContractTemplate.IntParameterValue(7, withdrawingWindow), (Object)new ContractTemplate.IntParameterValue(8, amount), (Object)new ContractTemplate.IntParameterValue(9, expiryRound), (Object)new ContractTemplate.BytesParameterValue(12, lease == null ? new Lease() : lease), (Object)new ContractTemplate.AddressParameterValue(15, receiver));
        return ContractTemplate.inject(Encoder.decodeFromBase64(referenceProgram), (List<ContractTemplate.ParameterValue>)values);
    }

    public static SignedTransaction MakeWithdrawalTransaction(ContractTemplate contract, int firstValid, Digest genesisHash, int feePerByte) throws IOException, NoSuchAlgorithmException {
        Logic.ProgramData data = ContractTemplate.readAndVerifyContract(contract.program, 7, 2);
        int maxFee = data.intBlock.get(1);
        int period = data.intBlock.get(2);
        int withdrawingWindow = data.intBlock.get(4);
        int amount = data.intBlock.get(5);
        Lease lease = new Lease(data.byteBlock.get(0));
        Address receiver = new Address(data.byteBlock.get(1));
        if (firstValid % period != 0) {
            throw new IllegalArgumentException("invalid contract: firstValid must be divisible by the period");
        }
        LogicsigSignature lsig = new LogicsigSignature(contract.program);
        Transaction tx = ((PaymentTransactionBuilder)((PaymentTransactionBuilder)((TransactionParametersBuilder)((PaymentTransactionBuilder)((PaymentTransactionBuilder)((PaymentTransactionBuilder)((TransactionParametersBuilder)((PaymentTransactionBuilder)Transaction.PaymentTransactionBuilder().sender(contract.address)).receiver(receiver)).fee(feePerByte)).firstValid(firstValid)).lastValid(firstValid + withdrawingWindow)).amount(amount)).genesisHash(genesisHash)).lease(lease)).build();
        if (tx.fee.longValue() > (long)maxFee) {
            throw new RuntimeException("Withrawl transaction fee too high: " + tx.fee + " > " + maxFee);
        }
        if (!lsig.verify(tx.sender)) {
            throw new IllegalArgumentException("Failed to verify transaction.");
        }
        return Account.signLogicsigTransaction(lsig, tx);
    }
}

