/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.templates;

import com.algorand.algosdk.account.Account;
import com.algorand.algosdk.builder.transaction.AssetTransferTransactionBuilder;
import com.algorand.algosdk.builder.transaction.PaymentTransactionBuilder;
import com.algorand.algosdk.builder.transaction.TransactionBuilder;
import com.algorand.algosdk.builder.transaction.TransactionParametersBuilder;
import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.crypto.Digest;
import com.algorand.algosdk.crypto.LogicsigSignature;
import com.algorand.algosdk.logic.Logic;
import com.algorand.algosdk.templates.ContractTemplate;
import com.algorand.algosdk.transaction.SignedTransaction;
import com.algorand.algosdk.transaction.Transaction;
import com.algorand.algosdk.transaction.TxGroup;
import com.algorand.algosdk.util.Encoder;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Objects;

@Deprecated
public class LimitOrder {
    protected static String referenceProgram = "ASAKAAEFAgYEBwgJCiYBIP68oLsUSlpOp7Q4pGgayA5soQW8tgf8VlMlyVaV9qITMRYiEjEQIxIQMQEkDhAyBCMSQABVMgQlEjEIIQQNEDEJMgMSEDMBECEFEhAzAREhBhIQMwEUKBIQMwETMgMSEDMBEiEHHTUCNQExCCEIHTUENQM0ATQDDUAAJDQBNAMSNAI0BA8QQAAWADEJKBIxAiEJDRAxBzIDEhAxCCISEBA=";

    public static ContractTemplate MakeLimitOrder(Address owner, Integer assetId, Integer ratn, Integer ratd, Integer expirationRound, Integer minTrade, Integer maxFee) throws NoSuchAlgorithmException {
        Objects.requireNonNull(owner);
        Objects.requireNonNull(assetId);
        Objects.requireNonNull(ratn);
        Objects.requireNonNull(ratd);
        Objects.requireNonNull(expirationRound);
        Objects.requireNonNull(minTrade);
        Objects.requireNonNull(maxFee);
        ImmutableList values = ImmutableList.of((Object)new ContractTemplate.IntParameterValue(5, maxFee), (Object)new ContractTemplate.IntParameterValue(7, minTrade), (Object)new ContractTemplate.IntParameterValue(9, assetId), (Object)new ContractTemplate.IntParameterValue(10, ratd), (Object)new ContractTemplate.IntParameterValue(11, ratn), (Object)new ContractTemplate.IntParameterValue(12, expirationRound), (Object)new ContractTemplate.AddressParameterValue(16, owner));
        byte[] program = Encoder.decodeFromBase64(referenceProgram);
        return ContractTemplate.inject(program, (List<ContractTemplate.ParameterValue>)values);
    }

    public static byte[] MakeSwapAssetsTransaction(ContractTemplate contract, Integer assetAmount, Integer microAlgoAmount, Account sender, Integer firstValid, Integer lastValid, Digest genesisHash, Integer feePerByte) throws IOException, NoSuchAlgorithmException {
        Logic.ProgramData data = ContractTemplate.readAndVerifyContract(contract.program, 10, 1);
        Address owner = new Address(data.byteBlock.get(0));
        int maxFee = data.intBlock.get(2);
        int minTrade = data.intBlock.get(4);
        int assetId = data.intBlock.get(6);
        int ratd = data.intBlock.get(7);
        int ratn = data.intBlock.get(8);
        if (assetAmount * ratd != microAlgoAmount * ratn) {
            throw new IllegalArgumentException("The exchange ratio of assets to microalgos must be exactly " + ratn + " / " + ratd + ", received " + assetAmount + " / " + microAlgoAmount);
        }
        if (microAlgoAmount < minTrade) {
            throw new IllegalArgumentException("At least " + minTrade + " microalgos must be requested.");
        }
        Transaction tx1 = ((TransactionBuilder)((PaymentTransactionBuilder)((PaymentTransactionBuilder)((PaymentTransactionBuilder)((PaymentTransactionBuilder)((PaymentTransactionBuilder)((PaymentTransactionBuilder)Transaction.PaymentTransactionBuilder().sender(contract.address)).fee(feePerByte)).firstValid(firstValid)).lastValid(lastValid)).genesisHash(genesisHash)).amount(microAlgoAmount)).receiver(sender.getAddress())).build();
        Transaction tx2 = ((TransactionBuilder)((AssetTransferTransactionBuilder)((AssetTransferTransactionBuilder)((AssetTransferTransactionBuilder)((AssetTransferTransactionBuilder)((TransactionParametersBuilder)((AssetTransferTransactionBuilder)((AssetTransferTransactionBuilder)Transaction.AssetTransferTransactionBuilder().sender(sender.getAddress())).assetReceiver(owner)).assetAmount(assetAmount)).fee(feePerByte)).firstValid(firstValid)).lastValid(lastValid)).genesisHash(genesisHash)).assetIndex(assetId)).build();
        if (tx1.fee.longValue() > (long)maxFee || tx2.fee.longValue() > (long)maxFee) {
            long fee = Math.max(tx1.fee.longValue(), tx2.fee.longValue());
            throw new RuntimeException("Transaction fee is greater than maxFee: " + fee + " > " + maxFee);
        }
        TxGroup.assignGroupID(tx1, tx2);
        LogicsigSignature lsig = new LogicsigSignature(contract.program);
        SignedTransaction stx1 = new SignedTransaction(tx1, lsig, tx1.txID());
        SignedTransaction stx2 = sender.signTransaction(tx2);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(Encoder.encodeToMsgPack(stx1));
        baos.write(Encoder.encodeToMsgPack(stx2));
        return baos.toByteArray();
    }
}

